% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology2nd.r
\name{topology2nd}
\alias{topology2nd}
\title{Higher order topology and correlation between node degrees}
\usage{
topology2nd(NET, Lowercase = 1, col.1 = 1, col.2 = 2, echo = 1,
  main = "Higher order topology")
}
\arguments{
\item{NET}{Either a text network file or an R list imported with \code{import.net}}

\item{Lowercase}{Render gene/protein IDs lower-case.}

\item{col.1}{Number of the column in the input file that corresponds to node 1 (gene/protein ID).}

\item{col.2}{Number of the column in the input file that corresponds to node 2 (gene/protein ID).}

\item{echo}{if execution progress should be reported.}

\item{main}{The plot title.}
}
\description{
Auxiliary function to estimate how non-random are associations of node degrees in network edges.
}
\examples{
data(net.kegg)
net <- net.kegg
topology2nd(NET=net, main="Second order topology in KEGG network")
}
\seealso{
\code{\link{connectivity}}, \code{\link{benchmark}}
}

