% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{updateRepresentation}
\alias{updateRepresentation}
\title{Update Representation}
\usage{
updateRepresentation(NGLVieweR_proxy, name, param = list())
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{name}{Name of representation to alter the color.}

\item{param}{Options for the different types of representations. Most common options are \code{name}, \code{opacity}, \code{colorScheme}, \code{colorValue} and \code{visibility}.
For a full list of options, see the general "RepresentationParameters" method and type specific Label-, Structure- and Surface- RepresentationParameters in the official \href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message parameters.
}
\description{
Update an existing NGLVieweR representation in Shinymode.
}
\examples{
\dontrun{
NGLVieweR_proxy("structure") \%>\%
  updateRepresentation("cartoon",
    param = list(
      name = "cartoon",
      color = isolate(input$color),
      opacity = isolate(input$opacity)
    )
  )
}

if (interactive()) {
library(shiny)

ui = fluidPage(
  titlePanel("Viewer with API inputs"),
  sidebarLayout(
    sidebarPanel(
      selectInput("color", "Color", c("red", "white", "blue")),
      sliderInput("opacity", "Opacity", 0, 1, 1),
      actionButton("update", "Update"),
    ),
    mainPanel(
      NGLVieweROutput("structure")
    )
  )
)
server = function(input, output) {
  output$structure <- renderNGLVieweR({
    NGLVieweR("7CID") \%>\%
      addRepresentation("cartoon", 
                        param = list(name = "cartoon", color="red"))
  })
observeEvent(input$update, {
  NGLVieweR_proxy("structure") \%>\%
    updateRepresentation("cartoon",
      param = list(
        color = isolate(input$color),
        opacity = isolate(input$opacity)
      )
    )
})
 }
shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=addSelection]{addSelection()}} Add a new selection to a NGLVieweR object.
\item \code{\link[=addRepresentation]{addRepresentation()}}
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "updateRepresentation".
}

Other updates: 
\code{\link{updateColor}()},
\code{\link{updateStage}()},
\code{\link{updateVisibility}()}
}
\concept{updates}
