#' Simulating Neutral Landscape Models
#'
#' \emph{NLMR} is an R package for simulating neutral landscape models (NLM).
#'
#' @details This package contains vignettes that introduce NLM and basic usage
#' of the \emph{NLMR} package. The vignettes in this package are listed below.
#'
#' \describe{
#' \item{\href{https://marcosci.github.io/NLMR/articles/background.html/}{NLM
#' Concepts + Terminology}}{Background information on the concepts and
#' terminology that underpin the simulation of neutral landscape models.}
#' \item{\href{https://marcosci.github.io/NLMR/articles/bestiary.html/}{NLMR
#' Bestiary}}{Bestiary of the available neutral landscape models.}
#' \item{\href{https://marcosci.github.io/NLMR/articles/getstarted.html/}{
#' Quickstart Guide}}{Short walk-through of the \emph{NLMR} package and how to
#' handle the simulations.}
#' }
#'

# nocov start
# nolint start
"_PACKAGE"

globalVariables(c("x", "value", "."))

# nolint end
# nocov end
