% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_random.R
\name{nlm_random}
\alias{nlm_random}
\title{nlm_random}
\usage{
nlm_random(ncol, nrow, resolution = 1, rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns forming the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows forming the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{rescale}{[\code{logical(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Simulates a spatially random neutral landscape model with values
drawn a uniform distribution.
}
\details{
The function takes the number of columns and rows as input and creates a
RasterLayer with the same extent. Each raster cell is randomly assigned a
value between 0 and 1 drawn from an uniform distribution (\code{runif(1,0,1)}).
}
\examples{
# simulate spatially random model
random <- nlm_random(ncol = 200, nrow = 100)

\dontrun{
# visualize the NLM
landscapetools::util_plot(random)
}

}
