% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Co.UPM}
\alias{Co.UPM}
\title{Co-Upper Partial Moment
(Upper Right Quadrant 1)}
\usage{
Co.UPM(degree_upm, x, y, target_x, target_y)
}
\arguments{
\item{degree_upm}{integer; Degree for upper variations of both variable X and Y.  \code{(degree_upm = 0)} is frequency, \code{(degree_upm = 1)} is area.}

\item{x}{a numeric vector.   \link{data.frame} or \link{list} type objects are not permissible.}

\item{y}{a numeric vector of equal length to \code{x}.   \link{data.frame} or \link{list} type objects are not permissible.}

\item{target_x}{numeric; Target for upside deviations of variable X.  Typically the mean of Variable X for classical statistics equivalences, but does not have to be.}

\item{target_y}{numeric; Target for upside deviations of variable Y.  Typically the mean of Variable Y for classical statistics equivalences, but does not have to be.}
}
\value{
Co-UPM of two variables
}
\description{
This function generates a co-upper partial moment between two equal length variables for any degree or target.
}
\examples{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
Co.UPM(0, x, y, mean(x), mean(y))
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments" (ISBN: 1490523995)
}
\author{
Fred Viole, OVVO Financial Systems
}
