% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{NNdatasets}
\alias{NNdatasets}
\title{All Datasets in One List}
\description{
\code{NNdatasets} is a list with the 12 datasets presented in this package and the 
recommended number of hidden neurons for each neural network model. 

\itemize{
  \item{mDette:    5 neurons.}
  \item{mFriedman: 5 neurons.}
  \item{mIshigami: 10 neurons.}
  \item{mRef153:   3 neurons.}
  \item{uDmod1:    6 neurons.}
  \item{uDmod2:    5 neurons.}
  \item{uDreyfus1: 3 neurons.}
  \item{uDreyfus2: 3 neurons.}
  \item{uGauss1:   5 neurons.}
  \item{uGauss2:   4 neurons.}
  \item{uGauss3:   4 neurons.}
  \item{uNeuroOne: 2 neurons.}
}

Each item of the list is itself a list with 5 components:
\itemize{
\item{ds: character. The name of the dataset.}
\item{neur: integer. The recommanded number of hidden neurons in the NN model and in 
\code{fmlaNN}.}
\item{nparNN: integer. The number of parameters in \code{fmlaNN}.}
\item{fmlaNN: the formula of the corresponding neural network, with tanh() as the
activation function in the hidden layer.}
\item{Z: matrix or data.frame. The dataset itself.}
}
Using \code{attach()} and \code{detach()} gives a direct access to these items.
}
\examples{
ht(NNdatasets, n = 2, l = 6)

NNdataSummary(NNdatasets)

}
\keyword{datasets}
