% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWeatherData.R
\name{getWeatherData}
\alias{getWeatherData}
\title{get Weather data}
\usage{
getWeatherData(online = TRUE, location, state, from = "2017-01-01",
  to = "2017-01-02", range = NA)
}
\arguments{
\item{online}{if TRUE(default),realtime data is pulled from the API. if FALSE, data is pulled from sample offline database}

\item{location}{Valid location supported by NOAA, use \code{\link{getAllLocations}} for view avaialble locations.}

\item{state}{Valid two letter code of US state}

\item{from}{Beginning of date range. Default: 2017-01-01}

\item{to}{End of date rage. Default: 2017-01-02}

\item{range}{Select other available locations  within the radial distance of specified location}
}
\value{
a dataframe of with all the metrics mentioned at hourly granularity
}
\description{
get Weather data from NOAA Web API for a given location, time period, and distance range in miles

 Available metrics:
   "p_official" : calculated Geonor precip total for hour (mm)
   "rh_std" : RH std dev for hour (percent)
   "solarad" : Average solar radiation for the hour (W m-2)
   "t_ max" : Calculated maximum temp for hour (deg_C)
   "t_min" : Calculated minimum temp for hour (deg_C)
   "t_official" : calculated average temp for hour (deg_C)
   "windspd" : average 1.5m wind speed for the hour (m s-1)
   "ws_max" : 10sec maximum 1.5m wind speed for the hour (m s-1)
}
\examples{
\dontrun{
data <- getWeatherData(online=TRUE,
location="Austin",state="TX",from="2017-01-10",
to="2017-01-11")
data <- getWeatherData(online=FALSE,
location="Austin",state="TX",from="2017-01-10",
to="2017-01-11",range=120)
}
}
\author{
Sagar Ganapaneni (sagar123)
}
