% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoScatter.R
\name{cytoScatter}
\alias{cytoScatter}
\title{Scatterplot of flow cytometry data}
\usage{
cytoScatter(cytomatrix, dims2plot = c(1, 2), gating = NULL,
  scale_log = FALSE, xlim = NULL, ylim = NULL, gg.add = list(theme()))
}
\arguments{
\item{cytomatrix}{a \code{p x n} data matrix, of \code{n} cell observations measured over \code{p}
markers.}

\item{dims2plot}{a vector of length at least 2, indicating of the dimensions to be plotted.
Default is \code{c(1, 2)}.}

\item{gating}{an optional vector of length \code{n} indicating a known gating of the cells to be 
displayed. Default is \code{NULL} in which case no gating is displayed.}

\item{scale_log}{a logical Flag indicating wether the data should be plotted on the log scale.
Default is \code{FALSE}.}

\item{xlim}{a vector of length 2 to specify the x-axis limits. Only used if \code{dims2plot} is
of length 2Default is the data range.}

\item{ylim}{a vector of length 2 to specify the y-axis limits. Only used if \code{dims2plot} is
of length 2. Default is the data range.}

\item{gg.add}{A list of instructions to add to the ggplot2 instruction.  See \code{\link[ggplot2]{+.gg}}.
Default is \code{list(theme())}, which adds nothing.
to the plot.}
}
\description{
Scatterplot of flow cytometry data
}
\examples{

rm(list=ls())
#Number of data
n <- 500
#n <- 2000
set.seed(1234)
#set.seed(123)
#set.seed(4321)

# Sample data
m <- matrix(nrow=2, ncol=4, c(-1, 1, 1.5, 2, 2, -2, -1.5, -2))
p <- c(0.2, 0.1, 0.4, 0.3) # frequence des clusters

sdev <- array(dim=c(2,2,4))
sdev[, ,1] <- matrix(nrow=2, ncol=2, c(0.3, 0, 0, 0.3))
sdev[, ,2] <- matrix(nrow=2, ncol=2, c(0.1, 0, 0, 0.3))
sdev[, ,3] <- matrix(nrow=2, ncol=2, c(0.3, 0.15, 0.15, 0.3))
sdev[, ,4] <- .3*diag(2)
c <- rep(0,n)
z <- matrix(0, nrow=2, ncol=n)
for(k in 1:n){
 c[k] = which(rmultinom(n=1, size=1, prob=p)!=0)
 z[,k] <- m[, c[k]] + sdev[, , c[k]]\%*\%matrix(rnorm(2, mean = 0, sd = 1), nrow=2, ncol=1)
 #cat(k, "/", n, " observations simulated\\n", sep="")
}

cytoScatter(z)

}
