% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_est_pear.R
\name{cluster_est_pear}
\alias{cluster_est_pear}
\title{Gets a point estimate of the partition using posterior expected adjusted
Rand index (PEAR)}
\usage{
cluster_est_pear(c)
}
\arguments{
\item{c}{a list of vector of length \code{n}. \code{c[[j]][i]} is
the cluster allocation of observation \code{i=1...n} at iteration
\code{j=1...N}.}
}
\value{
a \code{list}:
 \itemize{
     \item{\code{c_est}:}{ a vector of length \code{n}. Point estimate of the partition}
     \item{\code{pear}:}{ a vector of length \code{N}. \code{pear[j]} is the
     posterior expected adjusted Rand index associated to partition \code{c[[j]]}}
     \item{\code{similarity}:}{  matrix of size \code{n x n}. Similarity matrix
     (see \code{\link{similarityMat}})}
     \item{\code{opt_ind}:}{ the index of the optimal partition
     among the MCMC iterations.}
 }
}
\description{
Gets a point estimate of the partition using posterior expected adjusted
Rand index (PEAR)
}
\references{
A. Fritsch, K. Ickstadt. Improved Criteria for Clustering Based
on the Posterior Similarity Matrix, in Bayesian Analysis, Vol.4 : p.367-392
(2009)
}
\seealso{
\code{\link{similarityMat}} \code{\link{similarityMatC}}
}
\author{
Chariff Alkhassim
}
