% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAP_sNiW_mmEM.R
\name{MAP_sNiW_mmEM}
\alias{MAP_sNiW_mmEM}
\alias{MAP_sNiW_mmEM_vague}
\alias{MAP_sNiW_mmEM_weighted}
\title{EM MAP for mixture of sNiW}
\usage{
MAP_sNiW_mmEM(xi_list, psi_list, S_list, hyperG0, init = NULL, K,
  maxit = 100, tol = 0.1, doPlot = TRUE, verbose = TRUE)

MAP_sNiW_mmEM_weighted(xi_list, psi_list, S_list, obsweight_list, hyperG0, K,
  maxit = 100, tol = 0.1, doPlot = TRUE, verbose = TRUE)

MAP_sNiW_mmEM_vague(xi_list, psi_list, S_list, hyperG0, K = 10, maxit = 100,
  tol = 0.1, doPlot = TRUE, verbose = TRUE)
}
\arguments{
\item{xi_list}{a list of length \code{n}, each element is a vector of size \code{d}
containing the argument \code{xi} of the corresponding allocated cluster.}

\item{psi_list}{a list of length \code{n}, each element is a vector of size \code{d}
containing the argument \code{psi} of the corresponding allocated cluster.}

\item{S_list}{a list of length \code{n}, each element is a matrix of size \code{d x d}
containing the argument \code{S} of the corresponding allocated cluster.}

\item{hyperG0}{prior mixing distribution used if \code{init} is \code{NULL}.}

\item{init}{a list for initializing the algorithm with the following elements: \code{b_xi},
\code{b_psi}, \code{lambda}, \code{B}, \code{nu}. Default is \code{NULL} in which case
the initialization of the algorithm is random.}

\item{K}{integer giving the number of mixture components.}

\item{maxit}{integer giving the maximum number of iteration for the EM algorithm.
Default is \code{100}.}

\item{tol}{real number giving the tolerance for the stopping of the EM algorithm.
Default is \code{0.1}.}

\item{doPlot}{a logical flag indicating wether the algorithm progression should be plotted.
Default is \code{TRUE}.}

\item{verbose}{logical flag indicating whether plot should be drawn. Default is \code{TRUE}.}

\item{obsweight_list}{a list of length \code{n} where each element is a vector of weights for
each sampled cluster at each MCMC iterations.}
}
\description{
Maximum A Posteriori (MAP) estimation of mixture of
Normal inverse Wishart distributed observations with an EM algorithm
}
\details{
\code{MAP_sNiW_mmEM} provides an estimation for the MAP of mixtures of
Normal inverse Wishart distributed observations. \code{MAP_sNiW_mmEM_vague} provides
an estimates incorporating a vague component in the mixture.
\code{MAP_sNiW_mmEM_weighted} provides a weigthed version of the algorithm.
}
\examples{
set.seed(1234)
hyperG0 <- list()
hyperG0$b_xi <- c(0.3, -1.5)
hyperG0$b_psi <- c(0, 0)
hyperG0$kappa <- 0.001
hyperG0$D_xi <- 100
hyperG0$D_psi <- 100
hyperG0$nu <- 20
hyperG0$lambda <- diag(c(0.25,0.35))

hyperG0 <- list()
hyperG0$b_xi <- c(1, -1.5)
hyperG0$b_psi <- c(0, 0)
hyperG0$kappa <- 0.1
hyperG0$D_xi <- 1
hyperG0$D_psi <- 1
hyperG0$nu <- 2
hyperG0$lambda <- diag(c(0.25,0.35))

xi_list <- list()
psi_list <- list()
S_list <- list()
w_list <- list()

for(k in 1:200){
 NNiW <- rNNiW(hyperG0, diagVar=FALSE)
 xi_list[[k]] <- NNiW[["xi"]]
 psi_list[[k]] <- NNiW[["psi"]]
 S_list[[k]] <- NNiW[["S"]]
 w_list [[k]] <- 0.75
}


hyperG02 <- list()
hyperG02$b_xi <- c(-1, 2)
hyperG02$b_psi <- c(-0.1, 0.5)
hyperG02$kappa <- 0.1
hyperG02$D_xi <- 1
hyperG02$D_psi <- 1
hyperG02$nu <- 4
hyperG02$lambda <- 0.5*diag(2)

for(k in 201:400){
 NNiW <- rNNiW(hyperG02, diagVar=FALSE)
 xi_list[[k]] <- NNiW[["xi"]]
 psi_list[[k]] <- NNiW[["psi"]]
 S_list[[k]] <- NNiW[["S"]]
 w_list [[k]] <- 0.25

}

map <- MAP_sNiW_mmEM(xi_list, psi_list, S_list, hyperG0, K=2, tol=0.1)

}
\author{
Boris Hejblum, Chariff Alkhassim
}

