% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_table}
\alias{get_table}
\title{Download Statistical Data}
\usage{
get_table(
  tbl_id,
  PERIOD = NULL,
  CODE = NULL,
  CODE1 = NULL,
  CODE2 = NULL,
  try = FALSE
)
}
\arguments{
\item{tbl_id}{character string, Table identification number}

\item{PERIOD}{character vector, Time}

\item{CODE}{character vector, Classification code (age, gender etc)}

\item{CODE1}{character vector, Classification code (age, gender etc)}

\item{CODE2}{character vector, Classification code (age, gender etc)}

\item{try}{logical: Should the main body of the function be wrapped by the function \code{\link[base]{try}}? See details.}
}
\value{
A data frame if the function is executed without error, but an object of class "try-error" containing the error message, if it fails. The data frame has following structure:
\describe{
 \item{TBL_ID}{Row number}
 \item{Period}{Time}
 \item{CODE}{Classification code}
 \item{SCR_MN}{Classification name in Mongolian}
 \item{SCR_ENG}{Classification name in English}
 \item{CODE1}{Classification code}
 \item{SCR_MN1}{Classification name in Mongolian}
 \item{SCR_ENG1}{Classification name in English}
 \item{CODE2}{Classification code}
 \item{SCR_MN2}{Classification name in Mongolian}
 \item{SCR_ENG2}{Classification name in English}
 \item{DTVAL_CO}{Data value}
}
}
\description{
It downloads a table, which contains statistical data, from the API \href{http://opendata.1212.mn/en/doc}{opendata.1212.mn} which is supported by \href{http://www.en.nso.mn}{National Statistical Office of Mongolia (NSO)}.
}
\details{
The NSO server returns "HTTP error 500" frequently. Due to the server error, error handling is supported. if \code{try} is \code{TRUE}, you have to write code with error handling as shown in the example.
}
\examples{
nso.data <- get_table(
  tbl_id = "DT_NSO_2400_015V2",
  PERIOD = c("201711", "201712", "201801"),
  CODE = c("10", "11"),
  CODE1 = "11",
  try = TRUE
)
if (!inherits(nso.data, "try-error")) {
  print(nso.data)
}
}
\references{
\url{http://opendata.1212.mn/en/doc/Api/POST-api-Data}
}
\seealso{
\link{all_tables}, \link{get_table_info}, \link{get_sector_info}
}
