% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{sprout}
\alias{sprout}
\alias{sprout,numeric,matrix-method}
\title{Sprout new \code{turtles}}
\usage{
sprout(n, patches, breed, heading, color, turtles)

\S4method{sprout}{numeric,matrix}(n, patches, breed, heading, color, turtles)
}
\arguments{
\item{n}{Integer. Vector of length 1 or of length the number of \code{patches}.
Number of new \code{turtles}
to create on each \code{patch}.}

\item{patches}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates.}

\item{breed}{Character. Vector of \code{breed} names.
Must be of length 1 or of length the number of \code{patches}.
If missing, \code{breed} = \code{turtle} for all the sprouted \code{turtles}.}

\item{heading}{Numeric. Vector of values between 0 and 360.
Must be of length 1 or of length the number of \code{patches}.
If missing, a random \code{heading} is assigned to each sprouted \code{turtle}.}

\item{color}{Character. Vector of \code{color} names.
Must be of length 1, of length the number of \code{patches} or
of length \code{sum(n)}.
If missing, \code{colors} are assigned using the function \code{rainbow(n)}.}

\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}
}
\value{
\code{AgentMatrix} including the new
sprouted \code{turtles}.
}
\description{
Create \code{n} new \code{turtles} on specific \code{patches}.
}
\details{
\code{nrow(patches)} must be equal to 1 or to \code{n}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If `turtles` is provided, the new `turtles` are added to
     the `turtles` when returned. The `who` numbers of the sprouted `turtles`
     therefore follow the ones from the `turtles`.
     All new sprouted `turtles` are placed at the end of the `agentMatrix` object.
     If no `turtles`
     is provided, a new `agentMatrix` is created and the `who` numbers
     start at 0.

     If `turtles` is provided and had additional variables created
     with `turtlesOwn()`, `NA` is given for these variables
     for the new sprouted `turtles`.
}\if{html}{\out{</div>}}
}
\examples{
t1 <- sprout(patches = cbind(pxcor = 2, pycor = 2), n = 3)
t2 <- sprout(patches = cbind(pxcor = 3, pycor = 3), n = 3, turtles = t1)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#sprout}
}
\author{
Sarah Bauduin
}
