% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{turtle}
\alias{turtle}
\alias{turtle,agentMatrix,numeric,missing-method}
\alias{turtle,agentMatrix,numeric,character-method}
\title{Select \code{turtles}}
\usage{
turtle(turtles, who, breed)

\S4method{turtle}{agentMatrix,numeric,missing}(turtles, who)

\S4method{turtle}{agentMatrix,numeric,character}(turtles, who, breed)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{who}{Integer. Vector of the \code{who} numbers for the selected \code{turtles}.}

\item{breed}{Characters. Vector of \code{breed} names for the selected \code{turtles}.
If missing, there is no distinction based upon \code{breed}.}
}
\value{
\code{AgentMatrix} of the selected \code{turtles} sorted in the order of
the \code{who} numbers requested. If \code{breed} was provided, the
\code{turtles} selected are of one of the \code{breed}.
}
\description{
Report the individuals among \code{turtles} based on their \code{who} numbers
and \code{breed}.
}
\details{
If no \code{turtle} matches the given \code{who} numbers, with potentially
one of the given
\code{breed}, inside \code{turtles}, then an empty \code{agentMatrix} is returned.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If there are duplicates `who` numbers among the `turtles`, the first
     matching `turtle` with the requested `who` number is returned.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
t2 <- turtle(t1, who = 2)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#turtle}
}
\author{
Sarah Bauduin
}
