% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_centrality.R
\name{nd.centrality}
\alias{nd.centrality}
\title{Centrality Distance}
\usage{
nd.centrality(A, out.dist = TRUE, mode = c("Degree", "Close",
  "Between"), directed = FALSE)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{mode}{type of node centrality definitions to be used.}

\item{directed}{a logical; \code{FALSE} as symmetric, undirected graph.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{features}{an \eqn{(N\times M)} matrix where rows are node centralities for each graph.}
}
}
\description{
Centrality is a core concept in studying the topological structure of
complex networks, which can be either defined for each node or edge.
\code{nd.centrality} offers 3 distance measures on node-defined centralities.
See this \href{https://en.wikipedia.org/wiki/Centrality}{Wikipedia page} for more
on network/graph centrality.
}
\examples{
## generate two types of adjacency matrices of size (3-by-3)
rbin1 = rbinom(9,1,0.8); mat1 = matrix(rbin1,nrow=3)
rbin2 = rbinom(9,1,0.2); mat2 = matrix(rbin2,nrow=3)

mattype1 = ceiling((mat1+t(mat1))/2); diag(mattype1)=0;
mattype2 = ceiling((mat2+t(mat2))/2); diag(mattype2)=0;

A = list()
for (i in 1:3){A[[i]]=mattype1} # first 3 are type-1
for (i in 4:6){A[[i]]=mattype2} # next  3 are type-2

## use 3 types of centrality measures
out1 <- nd.centrality(A,out.dist=FALSE,mode="Degree")
out2 <- nd.centrality(A,out.dist=FALSE,mode="Close")
out3 <- nd.centrality(A,out.dist=FALSE,mode="Between")

## visualize
par(mfrow=c(1,3))
image(out1$D, main="Degree")
image(out2$D, main="Closeness")
image(out3$D, main="Betweenness")

}
\references{
\insertRef{roy_modeling_2014}{NetworkDistance}
}
