% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpmEV.R
\name{cpmEV}
\alias{cpmEV}
\title{Connectome-based Predictive Modeling--External Validation}
\usage{
cpmEV(train_na, train_b, valid_na, valid_b, thresh = 0.01,
  overlap = FALSE, progBar = TRUE)
}
\arguments{
\item{train_na}{Training dataset
(an array from \code{\link{convertConnBrainMat}} function)}

\item{train_b}{Behavioral statistic for each participant for the \strong{training} neural data (a vector)}

\item{valid_na}{Validation dataset
(an array from \code{\link{convertConnBrainMat}} function)}

\item{valid_b}{Behavioral statistic for each participant for the \strong{validation} neural data (a vector)}

\item{thresh}{Sets an \strong{alpha} threshold for edge weights to be retained.
Defaults to .01}

\item{overlap}{Should leave-one-out cross-validation be used?
Defaults to FALSE (use full dataset, no leave-one-out).
Set to TRUE to select edges that appear in every leave-one-out cross-validation network (\emph{time consuming})}

\item{progBar}{Should progress bar be displayed?
Defaults to TRUE.
Set to FALSE for no progress bar}
}
\value{
Returns a list containing: 

\item{results}{A matrix contaning: r coefficient (r), p-value (p-value),
mean absolute error (mae), root mean square error (rmse)}

\item{posMask}{Positive connectivity for input in
\href{https://bioimagesuiteweb.github.io/webapp/connviewer.html}{BioImage Suite Connectivity Viewer}}

\item{negMask}{Negative connectivity for input in
\href{https://bioimagesuiteweb.github.io/webapp/connviewer.html}{BioImage Suite Connectivity Viewer}}
}
\description{
Applies the Connectome-based Predictive Modeling approach to neural data.
This method predicts a behavioral statistic using neural connectivity from the sample.
Results \strong{may} differ from \emph{Matlab} results because of robust GLM methodology.
This function is still in its \strong{testing phase}.
\strong{Please cite Finn et al., 2015; Rosenberg et al., 2016; Shen et al., 2017}
}
\references{
Finn, E. S., Shen, X., Scheinost, D., Rosenberg, M. D., Huang, J., Chun, M. M., Papademetris, X., Constable, R. T. (2015).
Functional connectome fingerprinting: Identifying individuals using patterns of brain connectivity.
\emph{Nature Neuroscience}, \emph{18}, 1664-1671.
doi: \href{https://doi.org/10.1038/nn.4135}{10.1038/nn.4135}

Rosenberg, M. D., Finn, E. S., Scheinost, D., Papademetris, X., Shen, X., Constable, R. T., Chun, M. M. (2016).
A neuromarker of sustained attention from whole-brain functional connectivity.
\emph{Nature Neuroscience}, \emph{19}, 165-171.
doi: \href{https://doi.org/10.1038/nn.4179}{10.1038/nn.4179}

Shen, X. Finn, E. S., Scheinost, D., Rosenberg, M. D., Chun, M. M., Papademetris, X., Constable, R. T. (2017).
Using connectome-based predictive modeling to predict individual behavior from brain connectivity.
\emph{Nature Protocols}, \emph{12}, 506-518.
doi: \href{https://doi.org/10.1038/nprot.2016.178}{10.1038/nprot.2016.178}

Wei, T. & Simko, V.(2017).
R package "corrplot": Visualization of a correlation matrix (Version 0.84).
Available from \url{https://github.com/taiyun/corrplot}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
