% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.OBREresult.R
\name{plot.OBREresult}
\alias{plot.OBREresult}
\title{Function that plot an OBREresult object.}
\usage{
\method{plot}{OBREresult}(x)
}
\arguments{
\item{x}{The OBREresult object (output of OBRE function) that has to be plotted.}
}
\value{
A graphical representation of an OBREresult obect. The plot is composed by four plots: the value of input data in logaritmic scale, the values of score function evaluated in the input data, the OBRE weights, the values of OBRE components.
}
\description{
The function computes the plot of the OBRE computation
}
\examples{
\donttest{# Generates the Normal distribution input for OBRE
distrForOBRE <- densityExpressions(strDistribution = "normal")
# Generates input data
simData = c(rnorm(100, 12, 1), rnorm(10, 10, 10))
# Estimates OBREresult object
estOBRE = OBRE(nvData = simData, strDistribution = "normal", nCParOBRE = 3)
plot(estOBRE)}

}

