% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.OEFPIL.R
\name{coef.OEFPIL}
\alias{coef.OEFPIL}
\title{Extract model coefficients from OEFPIL}
\usage{
\method{coef}{OEFPIL}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"OEFPIL"} (a result of a call to \code{OEFPIL}).}

\item{...}{other arguments.}
}
\value{
A named vector of estimated model coefficients extracted from an \code{"OEFPIL"} object.
}
\description{
Function which extracts the estimated model coefficients from an object of class \code{"OEFPIL"}.
}
\examples{

##Creating a data file (using steam data from MASS library)
library(MASS)
steamdata <- steam
colnames(steamdata) <- c("x","y")
startsteam <- list(b1 = 5, b2 = 8, b3 = 200)
k <- nrow(steamdata)
CM <- diag(rep(0.1,2*k))

##Creating an OEFPIL object
st1 <- OEFPIL(steamdata, y ~ b1 * 10^(b2 * x/ (b3 + x)), startsteam, CM, useNLS = FALSE)

##Use of coef function
coef(st1)

}
\seealso{
\code{\link{OEFPIL}}
}
