% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tunePareto.occ.R
\name{tunePareto.occ}
\alias{tunePareto.occ}
\title{Ordinal Classifier Cascade Tune Pareto Object}
\usage{
tunePareto.occ(base.classifier)
}
\arguments{
\item{base.classifier}{A predefined TuneParetoClassifier object used as binary classifier 
for the ordinal classifier cascade. There exist five classifier types that 
can be used: tunePareto.knn(), tunePareto.svm(), tunePareto.tree(), tunePareto.randomForest(),
tunePareto.NaiveBayes(). For more information about these classifier functions please refer to 
the corresponding help page of like \code{TunePareto::\link{tunePareto.knn}}.}
}
\value{
Returns an object of class TuneParetoClassifier (see: \code{TunePareto::\link{tuneParetoClassifier}}). 
This can be passed to the function trainTuneParetoClassifier (see: \code{TunePareto::\link{trainTuneParetoClassifier}}).
}
\description{
TunePareto wrapper for the ordinal classifier cascade.
}
\details{
The "tunePareto.occ" encapsulates the classifier of an ordinal classifier cascade.
Additionally, to the parameters of the corresponding base classifier the "class.order"
parameter can be provided. It is either a character vector, a numeric vector, 
or a vector representing a cascade of the following format '1>2>4'.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
# train classifier
model <- trainTuneParetoClassifier( 
         classifier  = tunePareto.occ( base.classifier = tunePareto.svm()),
         trainData   = data,
         trainLabels = labels,
         class.order = as.character(c(4,3,1,0)),
         kernel      = "linear",
         cost        = 1)
         
# predict labels
prediction <- predict(object = model, newdata = data)
}
