% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appStatic.R
\name{exportStaticApp}
\alias{exportStaticApp}
\title{Export and launch a static shiny specific to the provided results.}
\usage{
exportStaticApp(
  result,
  directory,
  logo = "ohdsi",
  title = "",
  background = TRUE,
  summary = TRUE,
  panelStructure = NULL,
  panelDetails = NULL,
  theme = NULL,
  open = rlang::is_interactive(),
  panels = lifecycle::deprecated()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{directory}{Directory to create the shiny.}

\item{logo}{Name of a logo or path to a logo. If NULL no logo is included.
Only svg format allowed for the moment.}

\item{title}{title of the shiny}

\item{background}{Whether to include a background panel. Background panel
content will be controlled from the generated background.md file.}

\item{summary}{Whether to include a panel with a summary of content in the
`result`.}

\item{panelStructure}{A named list of panel indetifiers to organise them in
dropdown menus.}

\item{panelDetails}{A named list to provide details for each one of the
panels, such as: result_id, result_type, title, icon, output_id, ... Name of
each element must be the identifier name of `panelStructure`.}

\item{theme}{Specify the theme for the Shiny application. You can either
select a predefined theme provided by the package (e.g., `"theme1"`), or
define a custom theme using `bslib::bs_theme()`. If using a custom theme, it
must be provided as a character string (e.g.,
`"bslib::bs_theme(bg = 'white', fg = 'black')"`).}

\item{open}{Whether to open the shiny app project.}

\item{panels}{deprecated.}
}
\value{
The shiny app will be created in directory.
}
\description{
Export and launch a static shiny specific to the provided results.
}
\examples{
exportStaticApp(
  result = omopgenerics::emptySummarisedResult(),
  directory = tempdir()
)

}
