% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superpixels.R
\name{superpixel_bbox_subset}
\alias{superpixel_bbox_subset}
\title{Bounding box for a subset of superpixel labels}
\usage{
superpixel_bbox_subset(superpixel_labels, superpixel_subset)
}
\arguments{
\item{superpixel_labels}{a matrix. The \emph{superpixel_labels} parameter corresponds to the output \emph{labels} of the \emph{superpixels} function}

\item{superpixel_subset}{a numeric or integer vector specifying the subset of superpixel segments.}
}
\description{
Bounding box for a subset of superpixel labels
}
\details{
This function should be utilized to return the bounding box for a subset of superpixel segments. To compute the bounding box for all superpixels use the \emph{superpixel_bbox} function.
}
\examples{

library(OpenImageR)


#-----------
# read image
#-----------

path = system.file("tmp_images", "slic_im.png", package = "OpenImageR")

im = readImage(path)

im = im[,, 1:3]


#--------------------
# compute superpixels
#--------------------

res = superpixels(input_image = im, method = "slic", superpixel = 200,

                  compactness = 20, return_labels = TRUE)


#-------------------------
# compute the bounding box   ( for subset of superpixels )
#-------------------------

bbox = superpixel_bbox_subset(res$labels, superpixel_subset = c(0, 10, 30))

}
