% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listOMLTaskTypes.R
\name{listOMLTaskTypes}
\alias{listOMLTaskTypes}
\title{List available OpenML task types.}
\usage{
listOMLTaskTypes(verbosity = NULL)
}
\arguments{
\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{data.frame}].
}
\description{
The returned \code{data.frame} contains the type \code{id} and the character
name of the OpenML task type.
}
\note{
This function is memoised. I.e., if you call this function twice in a running R session,
the first call will query the server and store the results in memory while the second and all subsequent calls will return
the cached results from the first call.
You can reset the cache by calling \code{\link[memoise]{forget}} on the function manually.
}
\examples{
\dontrun{
  listOMLTaskTypes()
}
}
\seealso{
Other listing functions: \code{\link{listOMLDataSetQualities}},
  \code{\link{listOMLDataSets}},
  \code{\link{listOMLEstimationProcedures}},
  \code{\link{listOMLEvaluationMeasures}},
  \code{\link{listOMLFlows}}, \code{\link{listOMLRuns}},
  \code{\link{listOMLStudies}}, \code{\link{listOMLTasks}}

Other task-related functions: \code{\link{convertOMLTaskToMlr}},
  \code{\link{deleteOMLObject}}, \code{\link{getOMLTask}},
  \code{\link{listOMLTasks}}, \code{\link{makeOMLTask}},
  \code{\link{tagOMLObject}}
}
