% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repgrid-basicops.r
\name{cbind.repgrid}
\alias{cbind.repgrid}
\title{Concatenate the elements of two grids}
\usage{
\method{cbind}{repgrid}(..., .reorder = TRUE, .unique = FALSE)
}
\arguments{
\item{...}{\code{repgrid} objects or list of objects.}

\item{.reorder}{If \code{TRUE} (default), matches construct order of \code{y} to \code{x}.}

\item{.unique}{If \code{FALSE} (default), \code{x} and \code{y} may have common elements.
If \code{FALSE}, they must be mutually exclusive.}
}
\value{
\code{repgrid} with combined elements.
}
\description{
Concatenate the elements of two grids
}
\examples{
x <- boeker[, 1:2]
y <- boeker[, 5:7]
cbind(x, y)
x / y
y_reordered <- y[sample(nrow(y)), ]
cbind(x, y, y_reordered)
}
