% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimCART.R
\name{Optim.CART}
\alias{Optim.CART}
\title{Tune CART for the optimal complexity parameter}
\usage{
Optim.CART(formula, data, p, includedata = FALSE, seed = NULL, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ x1 + x2 + \dots}}

\item{data}{Data frame from which variables specified in  \code{formula} are preferentially to be taken.}

\item{p}{A percentage of training elements}

\item{includedata}{logicals. If TRUE the training and testing datasets are returned.}

\item{seed}{a single value, interpreted as an integer, or \code{NULL}. The default value is \code{NULL}, but for future checks of the model or models generated it is advisable to set a random seed to be able to reproduce it.}

\item{...}{arguments passed to \code{\link[rpart]{rpart}}}
}
\value{
An object of class \code{Optim}. See \code{\link{Optim.object}}
}
\description{
The complexity parameter aims to save computing time by pruning off splits that are obviously not worthwhile. This function starting with null value of \code{cp} and ranks the different possibles levels of pruning trees  find best CART for different levels of cost complexity.
 The main role of this parameter is to save computing time by pruning off splits that are obviously not worthwhile.
}
\details{
Classification And Regression Tree (CART) are a decision tree learning technique that produces either classification or regression trees, first introduced by
Breiman et al.(1984). Trees used for regression and trees used for classification have some similarities -
but also some differences, such as the procedure used to determine where to split.
}
\examples{
if(interactive()){
## Load a Dataset
data(AustralianCredit)
## Generate a model
modelFit <- Optim.CART(Y~., AustralianCredit, p = 0.7, seed=2018)
modelFit
}

}
\references{
Breiman L., Friedman J. H., Olshen R. A., and Stone, C. J. (1984) Classification and Regression Trees. Wadsworth.
}
