#' Mixture-amount experiment dataset (2 factors)
#'
#' A pharmaceutical mixture-amount experiment in two components
#'
#'@format A data frame with 360 observations on the following 3 variables.
#'\describe{
#' \item{Component_1}{Component 1 amount (mg)}
#' \item{Component_2}{Component 2 amount (mg)}
#' \item{Percent}{Percent of cells killed (response)}
#'}
#'@examples
#'plot(Drug[,1:2])
"Drug"
#' Central composite design experiment dataset (3 factors) 
#' 
#' \insertCite{BoxDraper;textual}{OptimaRegion}'s three factor experimental dataset
#' 
#' @format A data frame with 16 observations on the following 4 variables
#' \describe{
#'   \item{x1}{percentage concentration of the 1st constituent, in coded unit}
#'   \item{x2}{percentage concentration of the 2nd constituent, in coded unit}
#'   \item{x3}{temperature, in coded unit}
#'   \item{y}{elasticity of certain polymer}
#' }
#' 
#' @references{
#'   \insertAllCited{}
#' }
#' @importFrom Rdpack reprompt
"quad_3D"
#' Simulated dataset based on a cubic function (5 factors)
#' 
#' The dataset is simulated from the following function 
#' \deqn{
#' f(x) =  10 - (x_1-1.5)^2 - (x_2-2)^2 - (x_3-2.5)^2 - (x_4-3)^2- (x_5-3.5)^2 
#' + 0.1 x_1^3 - 0.1 x_2^3 - 0.1 x_3^3 - 0.1 x_4^3 - 0.1 x_5^3 + x_2 x_4 - x_3 x_4
#' }
#' defined in the region R = \{ 0 <= x_i <= 5, for i = 1, ...,  5\}, with its maximum at 
#' (2.28, 2.44, 1.02, 2.65, 2.54).
#' The sample locations are generated via a Hyper Latin Square (HLS) design within R,
#' and the noisy level is sigma = 2. 
#' 
#' @format A list consisting of 2 components:
#' \describe{
#'   \item{design_matrix}{300 design points generated by a HLS design within R}
#'   \item{responses}{300 noisy responses simulated at the design points with sigma = 2}
#' }
"cubic_5D"

