% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addFPOD.R
\name{addFPOD}
\alias{addFPOD}
\title{Add FPOD Detector to an AcousticStudy}
\usage{
addFPOD(x, fpod, detectorName = "FPOD")
}
\arguments{
\item{x}{an \linkS4class{AcousticStudy} object}

\item{fpod}{path(s) to CSV files containing FPOD detector output}

\item{detectorName}{name for the detector, the default \code{'FPOD'} should be
fine unless you want to differentiate between multiple FPOD detectors}
}
\value{
the same object as \code{x} with FPOD detector data added
}
\description{
Adds data from FPOD detector CSV files to an
  \linkS4class{AcousticStudy} object as new detectors of type
  \code{"fpod"}
}
\details{
FPOD detections are added to events based on their times. All detections
  between the start and end times events. NOTE: most \code{PAMpal} functions were designed
  with only PAMGuard data in mind, there is a chance that adding FPOD detections will
  cause other advanced functionality to not work.

  Behavior is slightly different depending
  on how the original AcousticStudy was created. For those processed with
  \code{mode='db'}, the start and end times for each event are just determined
  by the times of detections within the event.

  For those processed with
  \code{mode='recording'} or \code{mode='time'}, the start and end times for
  each event are determined by the start/end times of the recording files or
  the grouping file provided initially. This means that it is possible that
  there are events which initially had zero PAMGuard detections that now have
  FPOD detections. In these cases a new AcousticEvent will be created that only
  has FPOD detections, these events may not work with a variety of other \code{PAMpal}
  functions.
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
