% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDetectionBoxplot.R
\name{plotDetectionBoxplot}
\alias{plotDetectionBoxplot}
\title{Plot Detection Boxplot}
\usage{
plotDetectionBoxplot(
  x,
  group = "species",
  facet = NULL,
  color = hue_pal(),
  bin = "day/week",
  combineYears = FALSE,
  effort = NULL,
  dropZeroes = FALSE,
  returnData = FALSE
)
}
\arguments{
\item{x}{dataframe of detection data read in with \link{loadDetectionData}}

\item{group}{name(s) of columns indicating which rows of \code{x} are
distinct from each other, typically something like "site" or "species"
or both. These are used to define the different data points that go
in to each boxplot, see Details below for more information.}

\item{facet}{if not \code{NULL}, name of the column in \code{x} to facet
the plot by}

\item{color}{only used if \code{facet} is not \code{NULL}, colors to use
for each separate facet. Can either be a color palette function or a
character vector of color names. If a vector, it can be named by the
levels in \code{facet} that each color should correspond to}

\item{bin}{time bins to use for generating plot, must be a character of
format "time1/time2" where "time1" will be the y-axis of the plot and
"time2" will be the x-axis of the plot. Times are one of "hour", "day",
"week", or "month" (e.g. \code{"day/week"}).}

\item{combineYears}{logical flag to combine all observations to display
as a single "year"}

\item{effort}{if not \code{NULL}, a dataframe describing on effort times
to be formatted with \link{formatEffort}. If effort data is not provided
then times with zero detections will not be properly accounted for.}

\item{dropZeroes}{logical flag to remove boxplots where all observations
are zero (these would normally appear as a flat line at zero)}

\item{returnData}{if \code{TRUE} then no plot will be generated, instead the
dataframe that would normally be used to make the plot will be returned}
}
\value{
a ggplot object
}
\description{
Plots time series of boxplots showing detection data across time
}
\details{
The combination of \code{group}, \code{facet}, and
\code{combineYears} determine the data points that make up each boxplot.
If \code{combineYears=TRUE}, then there will be a different point for
each year. There will additionally be separate points for each different
value of the columns in \code{group}, excluding the column used for
\code{facet} (since these points are instead split out to different
facetted plots).

For example, if you have data from a single location, then settings of
\code{combineYears=FALSE}, \code{group='species'}, and \code{facet=NULL}
will create a plot where each point in a boxplot represents the number
of detections for a species. If you change to \code{facet='species'},
then the result will show a multi panel plot where each boxplot is just
a single point. Then changing to \code{combineYears=TRUE} will show
a multi panel plot where each point in a boxplot is the number of
detections for that panel's species in different years.
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
