% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.harmonic.R
\name{test.harmonic}
\alias{test.harmonic}
\title{Harmonic analysis test for Fast Fourier Transform}
\usage{
test.harmonic(ob, p, fft = FALSE, maxfreq = 10)
}
\arguments{
\item{ob}{Either the original observation or FFT results. See parameter \code{fft}.}

\item{p}{The p-value to be considered statistically significant.}

\item{fft}{If TRUE, \code{ob} is FFT results, with the first column frequencies and the second column signals in standardized proportions; if FALSE, \code{ob} is a vector of the original observation. The default is FALSE.}

\item{maxfreq}{To conduct test on at most \code{maxfreq} frequencies. The default is 10.}
}
\value{
A list of two elements:

\item{sig}{The significant frequencies plus the first insignificant frequency.}

\item{fft}{The FFT results expressed in standardized proportions.}
}
\description{
This function conducts harmonic test sequentially based on observations or Fast Fourier Transform (FFT)
results.
}
\examples{
data(pa3)

#### test on individuals
ob <- do.call("c",pa3$activity[1:4])
re <- test.harmonic(ob,p=0.05/(length(ob)-1)/2)
re$sig;head(re$fft) ## no harmonic is significant
ob2 <- do.call("c",pa3$activity[11:13])
re2 <- test.harmonic(ob2,p=0.05/(length(ob2)-1)/2)
re2$sig;head(re2$fft) ## 3 significant harmonics

#### test on the population average
re0 <- bandSelect(df=pa3,Nlength=1440*3,Nlambda=100,alpha=1,Ntop=3,
                  cross=FALSE,Ncross=NULL,plot=TRUE)
freq <- data.frame(Frequency=re0$freq,Proportion=colMeans(re0$xprop))
re3 <- test.harmonic(freq,p=0.05/nrow(freq),fft=TRUE)
print(re3$sig,digits=3,row.names=FALSE)

}
\references{
Fisher, R. A. (1929). Tests of significance in harmonic analysis. Proceedings of the Royal Society of London. Series A, 125(796), 54-59.
}
\seealso{
\code{\link{pharmonic}}
}
\keyword{harmonic}
\keyword{test}
