% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pnds.R
\name{get_pnds}
\alias{get_pnds}
\title{Download, label, deflate and create survey design object for PNDS microdata}
\usage{
get_pnds(
  year,
  section = "Female",
  vars = NULL,
  labels = TRUE,
  deflator = TRUE,
  design = TRUE,
  reload = TRUE,
  savedir = tempdir()
)
}
\arguments{
\item{year}{The year of the data to be downloaded. Must be a number equal to 2023. Vector not accepted.}

\item{section}{Argument corresponding to which section of the questionnaire will be obtained, being able to receive only the values of "Female" or "Male", the writing of the value must be identical to the indicated value. Default is to use the "Female" section of the questionnaire.}

\item{vars}{Vector of variable names to be kept for analysis. Default is to keep all variables.}

\item{labels}{Logical value. If \code{TRUE}, categorical variables will presented as factors with labels corresponding to the survey's dictionary.}

\item{deflator}{Logical value. If \code{TRUE}, deflator variables will be available for use in the microdata.}

\item{design}{Logical value. If \code{TRUE}, will return an object of class \code{survey.design} or \code{svyrep.design}. It is strongly recommended to keep this parameter as \code{TRUE} for further analysis. If \code{FALSE}, only the microdata will be returned.}

\item{reload}{Logical value. If \code{TRUE}, will re-download the files even if they already exist in the save directory. If \code{FALSE}, will be checked if the files already exist in the save directory and the download will not be performed repeatedly.}

\item{savedir}{Directory to save the downloaded data. Default is to use a temporary directory.}
}
\value{
An object of class \code{survey.design} or \code{svyrep.design} with the data from PNDS and its sample design, or a tibble with selected variables of the microdata, including the necessary survey design ones.
}
\description{
Core function of package. With this function only, the user can download a PNDS microdata from a year and get a sample design object ready to use with \code{survey} package functions.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-demografia-e-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
pnds.svy <- get_pnds(year=2023, section="Female", vars=c("J007","J009"),
                       labels=TRUE, deflator=TRUE, design=TRUE, reload=TRUE, savedir=tempdir())
# Calculating proportion of people diagnosed with chronic diseases
if (!is.null(pnds.svy)) survey::svymean(x=~J007, design=pnds.svy, na.rm=TRUE)
pnds.svy2 <- get_pnds(year=2023, section="Male", vars=c("N001","N00101"),
                       labels=TRUE, deflator=TRUE, design=TRUE, reload=TRUE, savedir=tempdir())
# Calculating proportion of people's self-rated health
if (!is.null(pnds.svy2)) survey::svymean(x=~N001, design=pnds.svy2, na.rm=TRUE)}
}
\seealso{
\link[PNDSIBGE]{read_pnds} for reading PNDS microdata.\cr \link[PNDSIBGE]{pnds_labeller} for labeling categorical variables from PNDS microdata.\cr \link[PNDSIBGE]{pnds_deflator} for adding deflator variables to PNDS microdata.\cr \link[PNDSIBGE]{pnds_design} for creating PNDS survey design object.\cr \link[PNDSIBGE]{pnds_example} for getting the path of the PNDS toy example files.
}
