% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEapply.R
\name{LEapply}
\alias{LEapply}
\alias{LEapply.Rcpp_POSet}
\title{Applies scalar functions over the set of linear extensions of a poset and returns the corresponding average values}
\usage{
LEapply(x, ...)

\method{LEapply}{Rcpp_POSet}(
  x,
  FUN = "MutualRankingProbability",
  ...,
  generator = c("AllLE", "BubleyDyer"),
  bubleydyer.precision = 10,
  bubleydyer.nit = NULL,
  degrees = NULL
)
}
\arguments{
\item{x}{an S4 object of class \code{Rcpp_POSet}, see \code{\link[POSetR]{poset}} for details.}

\item{...}{optional arguments to \code{FUN}.}

\item{FUN}{the function, or a list of functions, to be applied to each linear extension: see 'Details'.}

\item{generator}{a string specifying the method used to generate the linear extensions. The default value is \code{"AllLE"}. See section 'Details' below.}

\item{bubleydyer.precision}{considered only if \code{"BubleyDyer"} generator is selected. It corresponds to the number of digit precision of the frequencies in the sampling distributions of linear extensions.}

\item{bubleydyer.nit}{considered only if \code{"BubleyDyer"} generator is selected. Number of iterations in the Bubley-Dyer algorithm, if NULL (default) it is set as indicated in Bubley and Dyer (1999) depending on the value of \code{bubleydyer.precision} and the number of elements of the poset.}

\item{degrees}{to generate the lexicographic linear extensions of a product order, the poset \code{x} describes the dominance (e.g. relative importance) between ordinal variables and \code{degrees} is a numerical vector specifying the number of degrees of each variable, represented by in the poset.}
}
\value{
The average values of the argument functions \code{FUN} over the set of linear extensions (or lexicographic ones if \code{degrees} argument is not \code{NULL}).
}
\description{
\code{"LEapply"} is composed of three main elements: (i) the linear extensions generator, (ii) the application of the argument functions to the linear extensions and (iii) the computation of the averages of the results, for each function separately; see \insertRef{fattore2016partially}{POSetR}.
}
\details{
Argument \code{FUN} must be either a function or a list of functions, each one depending on a vector of characters representing the names of the elements of the poset.

If \code{degrees} is not \code{NULL} but a numerical vector as long as the number of elements in the poset, the poset elements are considered as ordinal variables. Therefore \code{degrees} represents their number of degrees that are represented as integer numbers starting from 0. In this case, \code{LEapply} generates the lexicographical linear extensions of the product order of the ordeinal variables. Its elements are called profiles and they are obtained by the combination of the degrees of variables separated by a dash. For details about lexicographical linear extensions and profiles see \insertRef{fattore2018reduced}{POSetR}.

Some functions are already implemented in the \code{C++} library and they can be called by their names. Currently, such functions are \code{"MutualRankingProbability"}, \code{"Separation"}, and \code{"AverageHeight"}.

Each function in \code{FUN} must return a numerical or logical matrix.
Each function can depend on additional arguments that can be passed through \code{...}; such additinal arguments must be the same for all the functions in the list.

Argument \code{generator} specifies the linear extension generation algorithm. The available generators are \code{"AllLE"}, that produces all of the linear extensions of the input poset, and \code{"BubleyDyer"}, which samples uniformly from the set of linear extensions, through an MCMC algorithm \insertCite{bubley1999faster}{POSetR}.
}
\examples{
dom <- matrix(c(
"a", "b",
"c", "b",
"b", "d"
), ncol = 2, byrow = TRUE)
p <- poset(x = dom)
plot(p)

LEapply(
  x = p,
  FUN = "MutualRankingProbability",
  generator = "AllLE",
  degrees = c(3, 2, 3, 2)
)

a_rank_dist <- function(le) {
  return(matrix(le == "a"))
}
LEapply(x = p, FUN = a_rank_dist)

LEapply <- function(x, ...) {
  UseMethod("LEapply")
}

}
\references{
\insertRef{bubley1999faster}{POSetR}

\insertRef{fattore2016partially}{POSetR}

\insertRef{fattore2018reduced}{POSetR}

\insertRef{habib2001efficient}{POSetR}
}
\seealso{
\code{\link[POSetR]{poset}}
}
