% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIfun.R
\name{ti.occurve}
\alias{ti.occurve}
\title{Operating Characteristic (OC) Curves for the PPQ Plan using Tolerance Interval.}
\usage{
ti.occurve(attr.name, attr.unit, Llim, Ulim, mu, sigma, n, n.batch, alpha,
coverprob, side, add.reference, NV)
}
\arguments{
\item{attr.name}{user-defined attribute name}

\item{attr.unit}{user-defined attribute unit}

\item{Llim}{lower specification limit}

\item{Ulim}{upper specification limit}

\item{mu}{hypothetical mean of the attribute}

\item{sigma}{hypothetical standard deviation of the attribute}

\item{n}{sample size (number of locations) per batch}

\item{n.batch}{number of batches for passing PPQ during validation}

\item{alpha}{significant level for constructing the tolerance interval.}

\item{coverprob}{converage probability for constructing the tolerance interval}

\item{side}{whether a 1-sided or 2-sided tolerance interval is required (determined by side = 1 or side = 2, respectively).}

\item{add.reference}{logical; if \code{TRUE}, then add reference OC curves (Baseline and High Performance) in the plot.}

\item{NV}{nominal volume for the specification test.}
}
\value{
OC curves for specification test and PPQ plan.
}
\description{
The function for  plotting the OC curve to show the PPQ plan based on the specification test, given lower and upper specification limits.
}
\examples{


ti.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%",
mu=97, sigma=seq(0.1, 10, 0.1), Llim=95, Ulim=105, n=10, add.reference=TRUE)

ti.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%",
mu=100, sigma=seq(0.1, 10, 0.1), Llim=95, Ulim=105, n=10, add.reference=TRUE)

ti.occurve(attr.name = "Extractable Volume", attr.unit = "\% of NV=3mL",
Llim = 100, Ulim = Inf, mu=102.5, sigma=seq(0.2, 6 ,0.05), n=40,
alpha = 0.05, coverprob = 0.97, side=1, NV=3)

ti.occurve(attr.name = "Extractable Volume", attr.unit = "\% of NV=3mL",
Llim = 100, Ulim = Inf, mu=102.5, sigma=seq(0.2, 6 ,0.05), n=40,
alpha = 0.05, coverprob = 0.992, side=1, NV=3)


}
\references{
Burdick, R. K., LeBlond, D. J., Pfahler, L. B., Quiroz, J., Sidor, L., Vukovinsky, K., & Zhang, L. (2017).
Statistical Applications for Chemistry, Manufacturing and Controls (CMC) in the Pharmaceutical Industry.
\emph{Springer}.
}
\seealso{
\code{ti.pp} and \code{rl.pp}.
}
\author{
Yalin Zhu
}
