% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIfun.R
\name{pi.occurve}
\alias{pi.occurve}
\title{Operating Characteristic (OC) Curves for the CQA PPQ Plan using Prediction Interval.}
\usage{
pi.occurve(attr.name, attr.unit, Llim, Ulim, mu, sigma, n, n.batch, alpha, add.reference)
}
\arguments{
\item{attr.name}{user-defined attribute name}

\item{attr.unit}{user-defined attribute unit}

\item{Llim}{lower specification limit}

\item{Ulim}{upper specification limit}

\item{mu}{hypothetical mean of the attribute}

\item{sigma}{hypothetical standard deviation of the attribute}

\item{n}{sample size (number of locations) per batch}

\item{n.batch}{number of batches for passing PPQ during validation}

\item{alpha}{significant level for constructing the prediction interval.}

\item{add.reference}{logical; if \code{TRUE}, then add reference OC curves (Baseline and High Performance) in the plot.}
}
\value{
OC curves for specification test and PPQ plan.
}
\description{
The function for plotting the OC curves and optimizing the baseline and high performance PPQ plans, given lower and upper specification limits.
}
\examples{
\dontrun{
pi.occurve(attr.name = "Total Protein", attr.unit = "mg/mL",
sigma = seq(0.01,1,0.01))
pi.occurve(attr.name = "Total Protein", attr.unit = "mg/mL",
sigma = seq(0.01,1,0.01), n.batch=3)
# Baseline curve
pi.occurve(attr.name = "Total Protein", attr.unit = "mg/mL",
sigma = seq(0.01,1,0.01), alpha = 0.1135434)
# High performance curve
pi.occurve(attr.name = "Total Protein", attr.unit = "mg/mL",
sigma = seq(0.01,1,0.01), alpha = 0.0225518)

# 95\% with reference curves
pi.occurve(attr.name = "Total Protein", attr.unit = "mg/mL",
sigma = seq(0.01,1,0.01), add.reference=TRUE)
pi.occurve(attr.name = "Composite Assay", attr.unit = "\%",
mu = 100, sigma = seq(0.1,6,0.1), Llim=95, Ulim=105, n.batch=1, add.reference=TRUE)

pi.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%",
mu=97, sigma=seq(0.1, 10, 0.1), Llim=95, Ulim=105, n=10, add.reference=TRUE)

pi.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%",
mu=100, sigma=seq(0.1, 10, 0.1), Llim=95, Ulim=105, n=10, add.reference=TRUE)

pi.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%",
mu=seq(95,105,0.1), sigma=1, Llim=95, Ulim=105, n=10, add.reference=TRUE)

pi.occurve(attr.name = "Protein Concentration", attr.unit="\%",
mu=seq(90, 110, 0.1), sigma=1.25, Llim=90, Ulim=110, add.reference=TRUE)
}
}
\references{
Burdick, R. K., LeBlond, D. J., Pfahler, L. B., Quiroz, J., Sidor, L., Vukovinsky, K., & Zhang, L. (2017).
Statistical Applications for Chemistry, Manufacturing and Controls (CMC) in the Pharmaceutical Industry.
\emph{Springer}.
}
\seealso{
\code{pi.pp} and \code{rl.pp}.
}
\author{
Yalin Zhu
}
