\name{plot.sbh}

\alias{plot.sbh}

\alias{plot}

\title{2D Visualization of Data Scatter and Box Vertices}

\description{
  S3-method \code{plot} function for two-dimensional visualization of original data as well as 
  predicted data scatter with cross-validated box vertices of a \code{sbh} object. 
  The scatter plot is for a given peeling step of the peeling sequence and in a given plane of
  the used covariates of the \code{sbh} object, both specified by the user.
}

\usage{
  \method{plot}{sbh}(x,
     main = NULL,
     proj = c(1,2), 
     splom = TRUE, 
     boxes = FALSE,
     steps = x$cvfit$cv.nsteps,
     pch = 16, 
     cex = 0.5, 
     col = 2:(length(steps)+1), 
     col.box = 2:(length(steps)+1), 
     lty.box = rep(2,length(steps)), 
     lwd.box = rep(1,length(steps)),
     add.legend = TRUE, 
     device = NULL, 
     file = "Scatter Plot", 
     path=getwd(), 
     horizontal = FALSE, 
     width = 5, 
     height = 5, ...)
}

\arguments{
  \item{x}{
    Object of class \code{sbh} as generated by the main function \code{\link[PRIMsrc]{sbh}}.
  }
  \item{main}{
    \code{Character} \code{vector}. Main Title. Defaults to \code{NULL}.
  }
  \item{proj}{
    \code{Integer} \code{vector} of length two, specifying the two dimensions of the projection plane of
    of the used covariates of the \code{sbh} object. Defaults to first two dimensions: \{1,2\}.
  }
  \item{splom}{
    \code{Logical} scalar. Shall the scatter plot of points inside the box(es) be plotted? Default to \code{TRUE}.
  }
  \item{boxes}{
    \code{Logical} scalar. Shall the box vertices be plotted or just the scatter of points? Default to \code{FALSE}.
  }
  \item{steps}{
    \code{Integer} \code{vector}. Vector of peeling steps at which to plot the in-box samples and box vertices. 
    Defaults to the last peeling step of \code{sbh} object.
  }
  \item{pch}{
    \code{Integer} scalar of symbol number for the scatter plot. Defaults to 16.
  }
  \item{cex}{
    \code{Integer} scalar of symbol expansion. Defaults to 0.5.
  }
  \item{col}{
    \code{Integer} \code{vector} specifying the symbol color for each step. 
    Defaults to vector of colors of length the number of steps. 
    The vector is reused cyclically if it is shorter than the number of steps.
  }
  \item{col.box}{
    \code{Integer} \code{vector} of line color of box vertices for each step. 
    Defaults to vector of colors of length the number of steps. 
    The vector is reused cyclically if it is shorter than the number of steps.
  }
  \item{lty.box}{
    \code{Integer} \code{vector} of line type of box vertices for each step. 
    Defaults to vector of 2's of length the number of steps. 
    The vector is reused cyclically if it is shorter than the number of steps.
  }
  \item{lwd.box}{
    \code{Integer} \code{vector} of line width of box vertices for each step. 
    Defaults to vector of 1's of length the number of steps. 
    The vector is reused cyclically if it is shorter than the number of steps.
  }
  \item{add.legend}{
    \code{Logical} scalar. Shall the legend of steps numbers be plotted? Defaults to \code{TRUE}.
  }
  \item{device}{
    Graphic display device in \{NULL, "PS", "PDF"\}. Defaults to NULL (standard output screen).
    Currently implemented graphic display devices are "PS" (Postscript) or "PDF" (Portable Document Format).
  }
  \item{file}{
    File name for output graphic. Defaults to "Scatter Plot".
  }
  \item{path}{
    Absolute path (without final (back)slash separator). Defaults to working directory path.
  }
  \item{horizontal}{
    \code{Logical} scalar. Orientation of the printed image. Defaults to \code{FALSE}, that is potrait orientation.
  }
  \item{width}{
    \code{Numeric} scalar. Width of the graphics region in inches. Defaults to 5.
  }
  \item{height}{
    \code{Numeric} scalar. Height of the graphics region in inches. Defaults to 5.
  }
  \item{\dots}{
    Generic arguments passed to other plotting functions.
  }
}

\details{
  The scatterplot is drawn only if the number of used covariates of the \code{sbh} object is greater than two.
  It is drawn on a graphical device with geometrically equal scales on the \eqn{x} and \eqn{y} axes.
}

\value{
  Invisible. None. Displays the plot(s) on the specified \code{device}.
}

\author{
    \itemize{
        \item "Jean-Eudes Dazard, Ph.D." \email{jean-eudes.dazard@case.edu}
        \item "Michael Choe, M.D." \email{mjc206@case.edu}
        \item "Michael LeBlanc, Ph.D." \email{mleblanc@fhcrc.org}
        \item "Alberto Santana, MBA." \email{ahs4@case.edu}
    }
    Maintainer: "Jean-Eudes Dazard, Ph.D." \email{jean-eudes.dazard@case.edu}
}

\references{
    \itemize{
        \item Dazard J-E. and Rao J.S. (2017).
              "\emph{Variable Selection Strategies for High-Dimensional Survival Bump Hunting using Recursive Peeling Methods.}"
              (in prep).
        \item Diaz-Pachon D.A., Dazard J-E. and Rao J.S. (2017).
              "\emph{Unsupervised Bump Hunting Using Principal Components.}"           
              In: Ahmed SE, editor. Big and Complex Data Analysis: Methodologies and Applications. 
              Contributions to Statistics, vol. Edited Refereed Volume. 
              Springer International Publishing, Cham Switzerland, p. 325-345.
        \item Yi C. and Huang J. (2016).
              "\emph{Semismooth Newton Coordinate Descent Algorithm for Elastic-Net Penalized Huber Loss Regression and Quantile Regression}."
              J. Comp Graph. Statistics, DOI: 10.1080/10618600.2016.1256816.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2016).
              "\emph{Cross-validation and Peeling Strategies for Survival Bump Hunting using Recursive Peeling Methods.}"
              Statistical Analysis and Data Mining, 9(1):12-42.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2015).
              "\emph{R package PRIMsrc: Bump Hunting by Patient Rule Induction Method for Survival, Regression and Classification.}"
              In JSM Proceedings, Statistical Programmers and Analysts Section. Seattle, WA, USA.
              American Statistical Association IMS - JSM, p. 650-664.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2014).
              "\emph{Cross-Validation of Survival Bump Hunting by Recursive Peeling Methods.}"
              In JSM Proceedings, Survival Methods for Risk Estimation/Prediction Section. Boston, MA, USA.
              American Statistical Association IMS - JSM, p. 3366-3380.
        \item Dazard J-E. and J.S. Rao (2010).
              "\emph{Local Sparse Bump Hunting.}"
              J. Comp Graph. Statistics, 19(4):900-92.
    }
}

\section{Acknowledgments}{
    This work made use of the High Performance Computing Resource in the Core Facility for Advanced Research Computing at Case Western Reserve University. 
    This project was partially funded by the National Institutes of Health NIH - National Cancer Institute (R01-CA160593) to J-E. Dazard and J.S. Rao.
}

\note{
  End-user plotting function.
}

\keyword{Exploratory Survival/Risk Analysis}
\keyword{Survival/Risk Estimation & Prediction}
\keyword{Non-Parametric Method}
\keyword{Cross-Validation}
\keyword{Bump Hunting}
\keyword{Rule-Induction Method}
