% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow-exclusions.r
\name{flow_exclusions}
\alias{flow_exclusions}
\alias{flow_exclusions_dot}
\title{Generic exclusions flow chart (beta)}
\usage{
flow_exclusions(incl_counts, total_label = "Total",
  incl_labels = LETTERS[seq_len(length(incl_counts) - 1)],
  excl_labels = paste("Not ", incl_labels), show_count = TRUE,
  percent_of_total = FALSE, percent_of_prev = FALSE,
  percent_args = list(), format_args = list(), font_size = NULL,
  dpi = NULL, ...)

flow_exclusions_dot(incl_counts, total_label = "Total",
  incl_labels = LETTERS[seq_len(length(incl_counts) - 1)],
  excl_labels = paste("Not ", incl_labels), show_count = TRUE,
  percent_of_total = FALSE, percent_of_prev = FALSE,
  percent_args = list(), format_args = list(), font_size = NULL,
  dpi = NULL, ...)
}
\arguments{
\item{percent_args}{\code{list} of arguments to pass to \code{scales::percent} for
formatting percentages. Default is an empty list.}

\item{format_args}{\code{list} of arguments to pass to \code{base::format} for
formatting counts. Default is an empty list.}

\item{...}{arguments passed to \code{flow_exclusions_dot}}
}
\description{
Generate the DOT description for a series of inclusions and
exclusions
}
\section{Functions}{
\itemize{
\item \code{flow_exclusions_dot}: Just generate the DOT text
}}

\examples{
flow_exclusions(c(1000, 300, 150, 75, 38))
dot <-
  flow_exclusions_dot(
    incl_counts = c(972, 132, 77, 14),
    total_label = "Total Screened",
    incl_labels = c("Consented", "Completed Study", "BMI <= 30"),
    excl_labels = c("Declined Consent", "Failed to Complete", "BMI > 30")
    )
DiagrammeR::grViz(dot)
flow_exclusions(c(1000, 300, 150, 75, 38),
                percent_of_total = TRUE,
                show_count = FALSE)
flow_exclusions(c(100000, 3000, 1666, 411, 38),
                percent_of_prev = TRUE,
                percent_args = list(decimal.mark = ","),
                format_args = list(scientific = TRUE),
                show_count = TRUE)
}
\keyword{internal}
