% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psw_mirror_hist.R
\name{psw.mirror.hist}
\alias{psw.mirror.hist}
\title{Mirror histogram}
\usage{
psw.mirror.hist(data, form.ps, weight, add.weight = FALSE, nclass = 50,
  K = 4)
}
\arguments{
\item{data}{data frame to be used.}

\item{form.ps}{propensity score model.}

\item{weight}{weighting method to be used. Available methods are \code{"ATE"},  \code{"ATT"}, \code{"ATC"}, \code{"MW"}, \code{"OVERLAP"}, and \code{"TRAPEZOIDAL"}.}

\item{add.weight}{add propensity score weights to the mirror histogram, \code{add.weight=FALSE} by default and it is not available for \code{weight="ATE", "ATT"} or \code{"ATC"}.}

\item{nclass}{number of breaks in the mirror histogram.}

\item{K}{value of \eqn{K} in \eqn{\omega(e_i) = min(1, K min(e_i, 1-e_i)) } for \code{"TRAPEZOIDAL"} weight.}
}
\value{
\code{NULL}.
}
\description{
\code{psw.mirror.hist} is used to plot the mirror histogram that visualizes the propensity score distributions in both treatment groups.
}
\details{
See \code{psw}.
}
\examples{
# Load the test data set
data(test_data);
# Propensity score model
form.ps <- "Z ~ X1 + X2 + X3 + X4";
tmp <- psw.mirror.hist( data = test_data, weight = "MW", form.ps = form.ps,
add.weight = TRUE );

}
\seealso{
\link{psw}
}
