% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idsummary.R
\name{idsummary}
\alias{idsummary}
\title{Internal Diffusion Models Summary}
\usage{
idsummary(t, qt, qinf, sort.by)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t}

\item{qinf}{the numerical value for the amount adsorbed at infinite time}

\item{sort.by}{the name of the statistical error parameter in which the models are sorted in either increasing or decreasing order. The only accepted arguments are "RMSE" for Relative Mean Square Error, 'MAE' for Mean Absolute Error, 'MSE' for Mean Squared Error, 'RAE' for Relative Absolute Error, 'AIC' for Akaike Information Criterion, 'BIC' for Bayesian Information Criterion, 'R2' for Coefficient of Determination, and 'SE' for Standard Error Estimate. This argument is case-sensitive, and failure to input the correct value will yield a summary of models in alphabetical order.}
}
\value{
the summarized error and parameter values from internal diffusion models.
}
\description{
Summarized results of parameter and error values collected from internal diffusion models, namely: Boyd Internal Diffusion, Crank, and Weber and Morris
}
\examples{
\donttest{
t  <- c(0,15,30,45,60,75,90,105,120)
qt <- c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
idsummary(t,qt,qinf=4.8,"SE")}
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
