\name{PSR-class}
\Rdversion{1.1}
\docType{class}
\alias{PSR-class}
\alias{plot,PSR-method}
\alias{show,PSR-method}

\title{Class \code{"PSR"}}
\description{
A S4 class that extends S4 PVR class in order to accommodate PSR analysis results.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("PSR", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{PSRarea}:}{Object of class \code{"data.frame"} that contains PSR curve area.}
    \item{\code{PSR}:}{Object of class \code{"data.frame"} that contais accumulated r squared and  eigenvalues.}
    \item{\code{Expect.area.values}:}{Object of class \code{"list"} that contains the expected null and neutral area values.}
    \item{\code{nullPSR}:}{Object of class \code{"matrix"} nested in the Expect.area.values slot that contains the expected null area values.}
    \item{\code{neutralPSR}:}{Object of class \code{"matrix"} nested in the Expect.area.values slot that contains the expected neutral area values.}
    \item{\code{Eigen}:}{Object of class \code{"list"} that contains the eigenvalues and eigenvectors generated by phylogenetic distance matrix eigendecomposition. Inherited from PVR class.}
    \item{\code{phyDist}:}{Object of class \code{"matrix"} that contains a phylogenetic distance matrix. Inherited from PVR class.}
    \item{\code{phylo}:}{Object of class \code{"phylo"} that contains a phylogeny. Inherited from PVR class.}
    \item{\code{Selection}:}{Object of class \code{"list"} that contains the selection method (along with its statistics) used to select the vectors, the selected vectors IDs and a matrix that contains the selected vectors. Inherited from PVR class.}
    \item{\code{PVR}:}{Object of class \code{"list"} that contains the \bold{P}hilogenetic  Eigen\bold{V}ectors \bold{R}egression r squared and residuals. Inherited from PVR class.}
    \item{\code{VarPart}:}{Object of class \code{"list"} that contains the variation partition components. Inherited from PVR class.}
  }
}
\section{Extends}{
Class \code{"\linkS4class{PVR}"}, directly.
}
\section{Methods}{
  \describe{
    \item{plot}{\code{signature(x = "PSR")}: ... }
    \item{show}{\code{signature(object = "PSR")}: ... }
	 }
}
\references{
Diniz-Filho, J.A.F., Sant'Ana, C.E.R. and Bini, L.M. (1998). An eigenvector method for estimating phylogenetic inertia. Evolution 52:1247-1262.

Legendre, P. and Legendre, L. (1998). Numerical ecology, 2nd Englished. Elsevier.

Diniz-filho, J.A.F., Rangel, T.F., Santos, T. and Bini, L.M. (2012). Exploring patterns of interespecific variation in quantitative traits using sequential phylogenetic eigenvector regressions. Evolution, 66(4):1079-1090.

Diniz-filho, J.A.F., Bini, L.M., Rangel, T.F., Morales-Castilla, I., Olalla-Tarraga, M.A., Rodriguez, M.A. and Hawkins, B.A. (2012). On the selection of phylogenetic eigenvectors for ecological analyses. Ecography, 35:239-249.
}
\author{
Santos, T; Diniz-Filho, J.A.F.; Rangel, T.F.; Bini, L.M.
}

\seealso{
\code{\link{PVR-class}}, \code{\link{PVR}}, \code{\link{PSR}},  \code{\link{PVRdecomp}},  \code{\link{PSRplot}},  \code{\link{VarPartplot}}
}
\examples{
showClass("PSR")
}
\keyword{classes}
