% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esriMap_plotOnStaticMap.R
\name{esriMap_plotOnStaticMap}
\alias{esriMap_plotOnStaticMap}
\title{Plot a map from a RGB rasterBrick.}
\usage{
esriMap_plotOnStaticMap(mapRaster, grayscale = FALSE, ...)
}
\arguments{
\item{mapRaster}{a RGB rasterBrick object. It is assumed that layer 1 represents red, layer 2 represents
gree, and layer 3 represents blue.}

\item{grayscale}{logical, if TRUE one layer is plotted with grayscale values. If FALSE, a color
map is plotted from red, green, and blue colors.}

\item{...}{arguments passed on to \code{plot} (for grayscale = TRUE) or \code{plotRGB} (for grayscale = FALSE)}
}
\value{
An plot of the map
}
\description{
The map is plotted using \code{plotRGB} from \pkg{raster}.
}
\examples{
\dontrun{
map <- esriMap_getMap(-122.3318, 47.668)
esriMap_plotOnStaticMap(map)
esriMap_plotOnStaticMap(map, grayscale = TRUE)
}
}
\seealso{
\code{\link{esriMap_getMap}}
}
\keyword{plotting}
