% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_loadAnnual.R
\name{airsis_loadAnnual}
\alias{airsis_loadAnnual}
\title{Load annual AIRSIS monitoring data}
\usage{
airsis_loadAnnual(
  year = NULL,
  parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring",
  dataDir = NULL
)
}
\arguments{
\item{year}{Desired year (integer or character representing YYYY).}

\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for 'annual' AIRSIS data files.}

\item{dataDir}{Local directory containing 'annual' data files.}
}
\value{
A \emph{ws_monitor} object with AIRSIS data.
}
\description{
Loads pre-generated .RData files containing annual
AIRSIS data.

If \code{dataDir} is defined, data will be loaded from this local
dirctory. Otherwise, data will be loaded from the monitoring data repository
maintained by PWFSL.

The annual files loaded by this function are updated on the 15'th of each
month and cover the period from the beginning of the year to the end of the
last month.

For data during the last 45 days, use \code{airsis_loadDaily()}.

For the most recent data, use \code{airsis_loadLatest()}.

AIRSIS parameters include the following:
\enumerate{
\item{PM2.5}
}

Available AIRSIS RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/AIRSIS/RData}{https://haze.airfire.org/monitoring/AIRSIS/RData}
}
\examples{
\dontrun{
airsis_loadAnnual(2017) \%>\%
  monitor_subset(stateCodes='MT', tlim=c(20170701,20170930)) \%>\%
  monitor_dailyStatistic() \%>\%
  monitor_timeseriesPlot(style = 'gnats', ylim=c(0,300), xpd=NA)
  addAQIStackedBar()
  addAQILines()
  title("Montana 2017 -- AIRSIS Daily Average PM2.5")
}
}
\seealso{
\code{\link{airsis_loadDaily}}

\code{\link{airsis_loadLatest}}
}
\keyword{AIRSIS}
