% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_downloadAnnual.R
\name{monitor_downloadAnnual}
\alias{monitor_downloadAnnual}
\title{Download annual PM2.5 monitoring data}
\usage{
monitor_downloadAnnual(
  year = NULL,
  parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring",
  dataDir = "~/Data/monitoring/RData",
  ...
)
}
\arguments{
\item{year}{Desired year (integer or character representing YYYY).}

\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for data files.}

\item{dataDir}{Local directory in which to save the data file.}

\item{...}{Additional arguments passed to \code{download.file}.}
}
\description{
Downloads 'annual' data files into \code{dataDir} for later use.
Downloaded versions of PWFSL monitoring .RData files allow users to work with
the package without access to the internet. Once data are downloaded to
\code{dataDir}, any of the data loading functions can be called with the
\code{dataDir} argument to replace internet downloads with local file access.

The recommended directory for PWFSL monitoring data is
\code{"~/data/monitoring/RData"}.

For data during the last 45 days, use \code{monitor_downloadDaily()}.

For the most recent data, use \code{monitor_downloadLatest()}.

Currently supported parameters include the following:
\enumerate{
\item{PM2.5}
}

Avaialble RData files can be seen at:
\href{https://haze.airfire.org/monitoring/latest/RData/}{https://haze.airfire.org/monitoring/latest/RData/}
}
\examples{
\donttest{
library(PWFSLSmoke)

monitor_loadAnnual(2018) \%>\%
  monitor_subset(stateCodes = "WA", tlim = c(20180701, 20181001)) \%>\%
  monitor_timeseriesPlot(style = 'gnats')
}
}
\seealso{
\code{\link{monitor_loadDaily}}
}
\keyword{AIRSIS}
\keyword{AirNow}
\keyword{WRCC}
