% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderOptPathPlot.R
\name{renderOptPathPlot}
\alias{renderOptPathPlot}
\title{Function for plotting optimization paths.}
\usage{
renderOptPathPlot(op, iter, x.over.time, y.over.time,
  contour.name = NULL, xlim = list(), ylim = list(), alpha = TRUE,
  log = NULL, colours = c("red", "blue", "green", "orange"),
  size.points = 3, size.lines = 1.5, impute.scale = 1,
  impute.value = "missing", scale = "std",
  ggplot.theme = ggplot2::theme(legend.position = "top"),
  marked = NULL, subset.obs, subset.vars, subset.targets, short.x.names,
  short.y.names, short.rest.names)
}
\arguments{
\item{op}{[\code{OptPath}]\cr
Optimization path.}

\item{iter}{[\code{integer(1)}]\cr
Selected iteration of \code{x} to render plots for.}

\item{x.over.time}{[\code{list} | NULL]
List of vectors of x-variables, either specified via name or id. If specified
via names, also extra measurements from the opt.path can be selected. Maximum
length for each vector is 5. For each list-element a line-plot iteration
versus variable is generated. If the vector has length > 2 only mean values
per iteration are plotted as lines, if vector has length 1 every point is
plotted. Default is to plot all variables into as few plots as possible.
Note that discrete variables are converted to numeric, if specified in the
same vector with numerics. Moreover, if more than 1 point per iteration
exists, mean values are calculated. This is also done for factor variables!
We recommend you to specify  this argument in a useful way.}

\item{y.over.time}{[\code{list} | NULL]
List of vectors of y-variables, either specified via name or id. If specified
via names, also extra measurements from the opt.path can be selected. Maximum
length for each vector is 5. For each list-element a line-plot iteration
versus variable is generated. If the vector has length > 2 only mean values
per iteration are plotted as lines, if vector has length 1 every point is
plotted. Default is to plot all variables into as few plots as possible.
Note that discrete variables are converted to numeric, if specified in the
same vector with numerics. Moreover, if more than 1 point per iteration
exists, mean values are calculated. This is also done for factor variables!
We recommend you to specify  this argument in a useful way.}

\item{contour.name}{[\code{character(1)} | NULL]
It is possible to overlay the XSpace plot with an contour plot. This is only
possible, if the XSpace has exact 2 numeric and 0 discrete variable. Consider
subsetting your variables to use this feature! contour.name is the name of the
target variable that will be used for the contour lines. Default is to use
the first target variable, if it is possible to add contour lines.}

\item{xlim}{[\code{list}] \cr
X axis limits for the plots. Must be a named list, so you can specify the
axis limits for every plot. Every element of the list must be a numeric
vector of length 2. Available names for elements are:
XSpace - limits for the X-Space plot
YSpace - limits for the Y-Space plot
Default is an empty list - in this case limits are automatically set.
Note: For some plots it is not meaningful to set limits, in this case the
set limits are ignored.
Note: We do not support setting lims for the over.time.plots. We think,
in nearly every case the ggplot defaults are fine, and the very rare case
you have to set them, you can you can extract the plots and add your own limits.}

\item{ylim}{[\code{list}] \cr
Y axis limits for the plots. Must be a named list, so you can specify the
axis limits for every plot. Every element of the list must be a numeric
vector of length 2. Available names for elements are:
XSpace - limits for the X-Space plot
YSpace - limits for the Y-Space plot
Default is an empty list - in this case limits are automatically set.
Note: For some plots it is not meaningful to set limits, in this case the
set limits are ignored.
Note: We do not support setting lims for the over.time.plots. We think,
in nearly every case the ggplot defaults are fine, and the very rare case
you have to set them, you can you can extract the plots and add your own limits.}

\item{alpha}{[\code{logical(1)}]\cr
Activates or deactivates the alpha fading for the plots. Default is \code{TRUE}.}

\item{log}{[\code{character}]\cr
Vector of variable names. All of this variable logarithmized in every plot.
Default is NULL - no logarithm is applied. Note that, if an
variable has only negative value, it is multiplied with -1. For variables
with both positive and negative values you have to do your own data preprocessing.}

\item{colours}{[\code{character(4)}]\cr
Colours of the points/lines for the four point types init, seq, prob and marked.
Default is red for init, blue for seq, green for prob and orange for marked.}

\item{size.points}{[\code{numeric(4)} | NULL]\cr
Size of points in the plot, default is 3.}

\item{size.lines}{[\code{numeric(4)} | NULL]\cr
Size of lines in the plots, default is 1.5.}

\item{impute.scale}{[\code{numeric(1)}]\cr
Numeric missing values will be replaced by \code{max + impute.scale * (max - min)}.
Default is \code{1}.}

\item{impute.value}{[\code{character(1)}]\cr
Factor missing values will be replaced by \code{impute.value}. Default is \code{missing}.}

\item{scale}{[\code{character(1)}]\cr
Parameter \code{scale} from the function \code{\link[GGally]{ggparcoord}} which is used for
the multiD-case. Default is \code{std}.}

\item{ggplot.theme}{Theme for the ggplots. Can be generated by \code{\link[ggplot2]{theme}}. Default is
\code{ggplot2::theme(legend.position = "top")}.}

\item{marked}{[\code{integer} | \code{character(1)} | NULL]\cr
\dQuote{best} or indices of points that should be marked in the plots.
If \code{marked = "best"} the best point for single crit optimization
respectively the pareto front for multi crit optimization is marked.
Default is \code{NULL} (no points are marked).}

\item{subset.obs}{[\code{integer}]\cr
Vector of indices to subset of observations to be plotted, default is all observations.
All indices must be available in the opt.path. But, to enable subsetting over multiple
iterations, not all indices must be available in the current iteration.
Indices not available in the current iteration will be ignored. Default is all observations.}

\item{subset.vars}{[\code{integer} | \code{character}]\cr
Subset of variables (x-variables) to be plotted. Either vector of indices or names.
Default is all variables.}

\item{subset.targets}{[\code{integer} | \code{character}]\cr
Subset of target variables (y-variables) to be plotted. Either vector of indices or names.
Default is all variables}

\item{short.x.names}{[\code{character}]\cr
Short names for x variables that are used as axis labels. Note you can
only give shortnames for variables you are using in \code{subset.vars}}

\item{short.y.names}{[\code{character}]\cr
Short names for y variables that are used as axis labels. Note you can
only give shortnames for variables you are using in \code{subset.targets}}

\item{short.rest.names}{[\code{character}]\cr
Short names for rest variables that are used as axis labels. Note you can
only give shortnames for variables you are used in \code{x.over.time}
or \code{y.over.time}.}
}
\value{
List of plots. List has up to elements:
  plot.x: Plot for XSpace. If both X and Y are 1D, Plot for both
  plot.y: Plot for YSpace. If both X and Y are 1D, NULL.
  plot.x.over.time: List of plots for x over time. Can also be NULL.
  plot.y.over.time: List of plots for y over time. Can also be NULL.
}
\description{
Same as \code{\link{plotOptPath}}, but renders the plots for just 1 iteration
and returns a list of plots instead of printing the plot. Useful, if you want
to extract single plots or to edit the ggplots by yourself.
}
