% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_related.R
\name{subsampler}
\alias{subsampler}
\title{Subsetting Results}
\usage{
subsampler(report, cov.filter = NA, sure.filter = NA, len.filter = NA,
  inc.combine = NA)
}
\arguments{
\item{report}{Dataframe of results produced
by \code{\link{subsampler}} or \code{\link{combine_results}}}

\item{cov.filter}{Filters results below percent read coverage specified (eg. 80)}

\item{sure.filter}{Filters results below sureness specified (eg. 0.75)}

\item{len.filter}{Filters plasmid sequences shorter than length specified (eg. 10000)}

\item{inc.combine}{Flag to ombine incompatibility sub-groups into their main type (set to 1)}
}
\value{
Report with filters applied
}
\description{
\preformatted{Several filters can be applied:
   Coverage: Filters results below percent read coverage specified
               eg. 95.9 cuts results where reads covered less than 95.9\% of the total length
   Sureness: Filters results below sureness specified
               eg. 0.9 cuts results where the sureness falls below 0.9
   Length:   Filters plasmid sequences shorter than length specified
               eg. 10000 cuts out results where the plasmid was less than 10kb
   Incompatibility groups can also be combined (eg. Fii(S) and Fii(K) are combined into Fii)}
}
\examples{
\dontrun{
subsampler(report, sureness.filter = 0.75, len.filter = 10000)
}
}
\seealso{
\code{\link{subsampler}}, \code{\link{combine_results}}
}

