% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_Vgene_usage.R
\name{VDJ_Vgene_usage}
\alias{VDJ_Vgene_usage}
\title{Produces a matrix counting the number of occurences for each VDJ and VJ Vgene combinations for each list enty in VDJ.clonotype.output or for each sample_id in VDJ.matrix}
\usage{
VDJ_Vgene_usage(VDJ, platypus.version)
}
\arguments{
\item{VDJ}{For platypus.version = "v2" output from VDJ_analyze function. This should be a list of clonotype dataframes, with each list element corresponding to a single VDJ repertoire. For platypus.version = "v3" output VDJ dataframe from VDJ_GEX_matrix function (VDJ_GEX_matrix.output[[1]])}

\item{platypus.version}{Character. Defaults to "v3". Can be "v2" or "v3" dependent on the input format}
}
\value{
Returns a list of matrices containing the number of Vgene heavy/light chain combinations per repertoire.
}
\description{
Produces a matrix counting the number of occurences for each VDJ and VJ Vgene combinations for each list enty in VDJ.clonotype.output or for each sample_id in VDJ.matrix
}
\examples{
example.vdj.vgene_usage <- VDJ_Vgene_usage(VDJ =
Platypus::small_vgm[[1]], platypus.version = "v3")

}
