% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_pseudobulk.R
\name{GEX_pseudobulk}
\alias{GEX_pseudobulk}
\title{Function that performs pseudo-bulking on the data (VGM input), according to criteria specified by the User, and uses the pseudo-bulked data to perform Differential Gene Expression (DGE) analysis.}
\usage{
GEX_pseudobulk(
  vgm.input,
  column.group,
  group1,
  group2,
  column.comparison,
  comparison,
  pool,
  platypus.version
)
}
\arguments{
\item{vgm.input}{Output of the VDJ_GEX_matrix function. Mandatory}

\item{column.group}{Character vector. Mandatory. Column name of VDJ_GEX_matrix[[2]] where the groups to be tested for differenetial gene expression are located}

\item{group1}{Strings vector. Mandatory. Samples to be grouped together for differential expression analysis against group2 (if pool=TRUE or column.comparison!=NULL). If pool=FALSE, vector containing samples to be tested individually against samples with the same index in the vector of group2.}

\item{group2}{Strings vector. Mandatory. Samples to be grouped together for differential expression analysis against group1 (if pool=TRUE or column.comparison!=NULL). If pool=FALSE, vector containing samples to be tested individually against samples with the same index in the vector of group1.}

\item{column.comparison}{Character vector. Defaults to NULL. Column name of VDJ_GEX_matrix[[2]] where the comparison cathegories are located, if DGE between group1 and group2 is performed across diferrent cathegories.}

\item{comparison, }{Strings vector. Defaults to NULL. Comparison cathegories, if more than one is present.}

\item{pool}{Logical. Defaults to FALSE. Indicates whether samples specified in group1 and group2 are to be pooled together within the same group.}

\item{platypus.version}{This function works with "v3" only, there is no need to set this parameter}
}
\value{
A data.frame or list of data.frames containing the results of the DGE analysis for every level of pseudo-bulking.
}
\description{
Function that performs pseudo-bulking on the data (VGM input), according to criteria specified by the User, and uses the pseudo-bulked data to perform Differential Gene Expression (DGE) analysis.
}
\examples{
\dontrun{
pseudo_DE<-GEX_pseudobulk(
vgm.input=VGM_NP396_GP33_GP66_labelled,
column.group="sample_id",
group1 = c("s1"), group2 = c("s4"),
column.comparison = "seurat_clusters",
comparison=c(2,3,5,9), pool=FALSE)
}

}
