% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_selection_expanded_clonotypes.R
\name{Spatial_selection_expanded_clonotypes}
\alias{Spatial_selection_expanded_clonotypes}
\title{Selection of VGM[[1]]/VDJ data of the x more expanded clonotypes.}
\usage{
Spatial_selection_expanded_clonotypes(nb_clonotype, vgm_VDJ)
}
\arguments{
\item{nb_clonotype}{Number that describes how many clonotypes we want to extract from the VGM[[1]].}

\item{vgm_VDJ}{Data frame containing VDJ information, found in the vgm made by platypus. It must have x and y coordinates column and the column containing the factor to plot.}
}
\value{
Returns a data frame with only the data belonging to the number of selected clonotypes. The clonotypes being the most expanded ones.
}
\description{
Selection of VGM[[1]]/VDJ data of the x more expanded clonotypes.
}
\examples{
\dontrun{
top_5_VDJ_data<-Spatial_selection_expanded_clonotypes(nb_clonotype = 5, vgm_VDJ = vgm$VDJ)
}
}
