% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_structure_analysis.R
\name{VDJ_structure_analysis}
\alias{VDJ_structure_analysis}
\title{Analysis of antibody structures}
\usage{
VDJ_structure_analysis(
  VDJ.structure,
  cells.to.vis,
  rank,
  rank.list,
  overlay,
  PDB.file,
  spin.speed,
  color.frameworks,
  color.cdr3,
  color.cdr2,
  color.cdr1,
  VDJ.anno,
  label,
  label.size,
  bk.opac,
  font.opac,
  font.col,
  anno.seq,
  color.molecule,
  color.sheets,
  color.helix,
  angle.x,
  angle.y,
  angle.z,
  r3dmol.code,
  plddt.plot,
  structure.plot,
  antigen.interaction,
  binding.site.cutoff,
  dist.mat,
  SASA,
  hydrophobicity,
  charge,
  metrics.plot,
  BindingResidues.plot,
  binding.residue.barplot,
  binding.residue.barplot.style
)
}
\arguments{
\item{VDJ.structure}{The VDJ.structure is a list object with the VDJ MIXCR out data frame as its first element containing the germline reference sequences. The second list element contains a list for every predicted structures with the top ranked predictions in pdb format read in by the bio3d:read_pdb() function.}

\item{cells.to.vis}{In the cells.to.vis argument, the barcodes of the cells that should be analyzed can be specified. It can be a single barcode or a list of barcodes. If all the elements of the VDJ.structure object shall be included, the cells.to.vis argument can be set to "ALL" (cells.to.vis = "ALL).}

\item{rank}{AlphaFold predicts multiple models for a given structure which are then ranked according to model's confidence with ranked_0.pdb as the best fit. By default the function uses the ranked_0 model but if a different rank is desired this can be specified in teh rank argument (rank = "ranked_5.pdb").}

\item{rank.list}{The function can also be used to analyze multiple ranked models per structure. This can be done by specifying the rank.list argument. rank.list = list("ranked_0.pdb", "ranked_1.pdb", "ranked_2.pdb") would use the top three most confident models per structure that are specified in the cells.to.vis argument.}

\item{overlay}{Multiple antibody structures are by default visualized separately. In case an overlay is desired this can be done by setting overlay to TRUE (overlay = T).}

\item{PDB.file}{Instead of visualizing the structure form the VDJ.structure object, the function can accept a path to a pdb.file as well.}

\item{spin.speed}{Protein animations can spin around an internal axis. By default the spin speed is set to 0. To start rotation the spin.speed argument can be set to the desired rotation speed.}

\item{color.frameworks}{The color of the frameworks can be changed by specifying the color.frameworks argument with a the desired color in HEX format (color.frameworks = "#eb4034")}

\item{color.cdr3}{The color of the cdr3 can be changed by specifying the color.cdr3 argument with a the desired color in HEX format (color.cdr3 = "#eb4034")}

\item{color.cdr2}{The color of the cdr2 can be changed by specifying the color.cdr2 argument with a the desired color in HEX format (color.cdr2 = "#eb4034")}

\item{color.cdr1}{The color of the cdr1 can be changed by specifying the color.cdr1 argument with a the desired color in HEX format (color.cdr1 = "#eb4034")}

\item{VDJ.anno}{When using a VDJ structure object as an input, the regions of the antibody are by default annotated based on the MIXCR columns. If annotation is not desired the VDJ.anno argument can be set to FALSE.}

\item{label}{By default the annotated regions are labeled. The label can be disabled by setting the label argument to FASLE.}

\item{label.size}{The label size can be adjusted by specifying the label.size argument. By default the label size is set to 12.}

\item{bk.opac}{The label background opacity can be defined with the bk.opac argument. The default opacity is 0.8.}

\item{font.opac}{The opacity of the label's font can be set by specifying the font.opac argument. The default opacity is 1.}

\item{font.col}{The color of the font can be set by the font.col argument. It has to be in a HEX format.}

\item{anno.seq}{By the anno.seq argument any residues of the structure can be annotated. Every domain of the structure is handled as a separate chain, named alphabetically from A-Z, according to the order in the FASTA file.  So for an anybody the HC is Chain A, the LC Chain B and the Antigen Chain C. The format of the anno.seq argument is a vector with the index of the starting residue as its first element, the index of the end residue as second element, the chain in the third element and the color in HEX format as the fourth element. Optionally a label can be added by specifying the text in the fifth element anno.seq = c(4,12,"C","#9900ff","label"). For annotating multiple sequences at once, a list of vectors can be used anno.seq = list(c(4,12,"C","#9900ff","label1"),c(4,12,"B","#9350ff","label2"),...)}

\item{color.molecule}{The color of the non annotated residues can be set by the color.molecule argument in HEX format.}

\item{color.sheets}{The color of beta sheets can be set by specifying the color.sheets argument with the desired color in HEX format.}

\item{color.helix}{The color of alpha helices can be set by specifying the color.helix argument with the desired color in HEX format.}

\item{angle.x}{The molecule can be rotated around the x-axis by setting the angle.x argument in degree.}

\item{angle.y}{The molecule can be rotated around the y-axis by setting the angle.y argument in degree.}

\item{angle.z}{The molecule can be rotated around the z-axis by setting the angle.z argument in degree.}

\item{r3dmol.code}{Additional r3dmol code to modify appearance of the final structure. Defaults to "". Character input is run via eval(parse(x))}

\item{plddt.plot}{AlphaFold has a pLDDT confidence score for every residue of the structure. An additional plot of the structure colored according to the pLDDT score will be returned by setting the plddt.plot to TRUE.}

\item{structure.plot}{By default the structure is visualized. However, if the function is only used to get binding site metrics, the structure.plot argument can be set to FALSE. Like this nos structures are plotted.}

\item{antigen.interaction}{If the antibody is predicted together with the antigen the antigen.interaction argument can be set to TRUE in order to get some binding site metrics. The function will determine the binding site residues based on the bio3d::binding.site() function as well as the average minimal distance of every binding site residue from the antibody to the antigen. Furthermore, the mean confidence (pLDDT) of the binding site residues is calculated. All the results are summarized in a data frame.}

\item{binding.site.cutoff}{Cutoff for the bio3d::binding.site() function. Default is 5.}

\item{dist.mat}{If set to TRUE, the binding residues distance matrix for every structure will be returned as a list. Default = FALSE, so only the minimal distances in the summary data frame is returned.}

\item{SASA}{if set to TRUE the Solvent Accessible Surface Area will be calculated for every Structure}

\item{hydrophobicity}{If set to TRUE, the per residue hydrophobicity will be calculated.}

\item{charge}{If set to TRUE, the per residue charge will be calculated.}

\item{metrics.plot}{If set to TRUE, a structure plot colored according to the metrics will be shown.}

\item{BindingResidues.plot}{If the antigen.interaction is enabled, the binding site residues can be visualized on the structure by setting the BindingResidues.plot argument to TRUE.}

\item{binding.residue.barplot}{The binding.residue.bar plot can be set to TRUE to get a bar plot visualizing to which regions of the antibody the binding site residues belong too. A bar plot is produced for every structure separately as well as one summary bar plot over all analyzed structures.}

\item{binding.residue.barplot.style}{There are two styles available for the binding site residue bar plot. By default all regions are listed separately. By setting the binding.residue.barplot.style to "FR_CDR", only framework and CDR is distinguished.}
}
\value{
ADD DESCRIPTION OF RETURN VALUE HERE
}
\description{
VDJ_structure_analysis is a Platypus function for the analysis of 3d structures of antibodies.
The function is designed in a way to be a follow up of the alphafold_prediction function of the Platypus package.
The input of this function is a list that has the VDJ MIXCR output in its first element and a list of structures in its second element.
This is the output format of the alphafold_prediction function. The function can also be used to visualize structures from PDB files directly.

The function can visualize the structures of proteins and is especially designed for visualization of antibodies, where the
framework and CDR regions are automatically annotated. If the antibody was predicted together with a antigen, the function can visualize
binding interaction and detect the binding site residues. Furthermore, it can determine binding site metrics as average distance and model accuracy.
The function has a variety of arguments to create the desired visualization.
}
\examples{
\dontrun{

ADD EXAMPLE CODE HERE

}
}
