% Generated by roxygen2 (4.0.1): do not edit by hand
\name{genotPPE}
\alias{genotPPE}
\title{Simple paternity exclusion for genotype allele data}
\usage{
genotPPE(adata)
}
\arguments{
\item{adata}{data frame: the preprocessed allele data set returned
by either \code{\link{inputData}} or \code{\link{preprocessData}}.}
}
\value{
A list whose components are described below.  The
components that are probably of primary interest to the user are
\code{adultTables$FLCount} and \code{adultTables$VLTotal}.  These
are likely to be large tables, so note that the functions
\code{\link{potentialFatherCounts}} and
\code{\link{potentialFatherIDs}} are available to usefully
summarise their content.

The list returned by \code{genotPPE} contains two elements,
\code{progenyTables} and \code{adultTables}, each of which are
themselves lists.

Element \code{adultTables} contains the following components:

\describe{

\item{\code{FLCount}}{Father Loci Count - a matrix, showing for
each progeny-candidate combination, the number of loci at which
the candidate matches (i.e., could have fathered) the progeny}

\item{\code{VLTotal}}{Valid Loci Total - a matrix, showing for
each progeny-candidate combination, the total number of loci at
which a valid comparison between progeny and candidate could be
made.  (Missing allele sets, whether in the original data, or due
to progeny-mother mismatches found by
\code{\link{preprocessData}}, can result in fewer loci at which
progeny-candidate (father) comparisons are possible.)}

\item{\code{fatherSummaryTable}}{A matrix, combining the results
of \code{FLCount} and \code{VLTotal} (see above) for each
progeny-candidate combination in one table.  This is purely for
ease of viewing purposes, but note also the functions
\code{\link{potentialFatherCounts}} and
\code{\link{potentialFatherIDs}} which may provide more useful
summary output.}

\item{\code{CPNotM.alleleArray}}{A 3D array containing the
alleles present in both candidate (father) and progeny, but not in
the progeny's mother (for each progeny/candidate/locus
combination)}

\item{\code{CMP.alleleArray}}{A 3D array containing the alleles
present in candidate, progeny and progeny's mother (for each
progeny/candidate/locus combination)}

\item{\code{simpleFatherArray}}{A 3D array indicating whether each
candidate is compatible with each progeny, for each locus}

}

\code{progenyTables} contains the following components:

\describe{

\item{\code{progenyStatusTable}}{A data frame, indicating the
status of the progeny / mother allele set comparison (for each
progeny, at each locus).}

\item{\code{MP.alleleTable}}{A data frame containing the alleles
that are found in both mother's and progeny's allele sets (for
each progeny, at each locus)}

\item{\code{PNotM.alleleTable}}{A data frame, containing the
alleles in the progeny's allele set, that are \emph{not} present
in the mother's allele set(for each progeny, at each locus)}

}

The status codes in \code{progenyTables$progenyStatusTable} are:

\describe{

\item{\code{"MAO"}}{Mother Alleles Only - the progeny contains
only alleles found also in the mother}

\item{\code{"NMA"}}{Non-Mother Alleles - the progeny contains
alleles that are not found in the mother}

\item{\code{"P.missing"}}{No comparison was possible at this locus
because the progeny's allele set was missing}

\item{\code{"P.missing"}}{No comparison was possible at this locus
because the mother's allele set was missing}

\item{\code{"PM.missing"}}{No comparison was possible at this
locus because both progeny's and mother's allele sets were
missing}

}

Note that some of the \code{"P.missing"} or \code{"PM.missing"}
codes may have arisen due to progeny / mother mismatches found
(and corresponding progeny allele sets removed) by
\code{\link{preprocessData}}.
}
\description{
Conduct a paternity exclusion analysis on a genotype dataset.
}
\details{
\code{genotPPE} conducts a basic paternity exclusion analysis on
a genotype dataset.

For the purposes of the PolyPatEx package, the term
\sQuote{genotype} refers to forms of marker data where the allele
copy numbers (or multiplicities) are known - hence for a polyploid
species of ploidy \emph{p}, there should be exactly \emph{p}
alleles detected at each locus, some of which may be repeats of
the same allele state.  In PolyPatEx, no allowance is made for
undetected alleles in genotype data - allele sets having fewer
than \emph{p} alleles present should have been reset to contain no
alleles by \code{\link{preprocessData}}.

For the above and other reasons, \code{genotPPE} should \bold{NOT}
be applied to a dataset that has not been preprocessed by
\code{\link{preprocessData}} (either by calling directly
\code{\link{preprocessData}} on the data frame directly, or by
using \code{\link{inputData}} to load the data from file).

The genotype-based paternity analysis is based on simple
comparison of genotype allele sets between mother, progeny, and
candidate father.  The mother-progeny relationship is assumed to
be known.  For genotype data, should a progeny contain only
alleles also present in its mother, then a potential father is any
candidate that can provide a gamete compatible with the progeny's
genotype, given the mother's genotype.
}
\examples{
## Using the example dataset 'FR_Genotype':
data(FR_Genotype)

## Since we did not load this dataset using inputData(), we must
## first process it with preprocessData() before doing anything
## else:
gData <- preprocessData(FR_Genotype,
                        numLoci=7,
                        ploidy=4,
                        dataType="genotype",
                        dioecious=TRUE,
                        mothersOnly=TRUE)

head(gData)  ## Checked and Cleaned version of FR_Genotype

gPPE <- genotPPE(gData)  ## Perform the exclusion analyses

## gPPE is a large (and rather ugly!) data structure - see
## functions potentialFatherCounts() and potentialFatherIDs() for
## more useful output from the gPPE object.
}
\author{
Alexander Zwart (alec.zwart at csiro.au)
}
\seealso{
\code{\link{phenotPPE}}
}

