\name{portfolio_expectedDownsideReturn}
\alias{portfolio_expectedDownsideReturn}
\title{Portfolio Expected Downside Return}
\usage{portfolio_expectedDownsideReturn(portfolio,thresholdReturn)
}
\arguments{
  \item{portfolio}{Portfolio object created using \link[=portfolio_create]{portfolio_create( )} function}
  \item{thresholdReturn}{Return value to be used as a cut-off point}
}
\value{
Numeric vector of portfolio expected downside returns.
}
\description{Computes portfolio cumulative expected return below a certain threshold.
}
\note{\url{https://www.portfolioeffect.com/docs/glossary/measures/absolute-return-measures/expected-downside-return}
}
\author{Kostin Andrey <andrey.kostin@portfolioeffect.com>}
\seealso{\code{\link{portfolio_expectedUpsideReturn}} }
\examples{
\dontrun{ 
data(aapl.data) 
data(goog.data) 
data(spy.data) 
portfolio<-portfolio_create(priceDataIx=spy.data)
portfolio_settings(portfolio,windowLength = '3600s',resultsSamplingInterval='60s')
portfolio_addPosition(portfolio,'GOOG',100,priceData=goog.data)  
portfolio_addPosition(portfolio,'AAPL',300,priceData=aapl.data) 
portfolio_addPosition(portfolio,'SPY',150,priceData=spy.data)
util_plot2d(portfolio_expectedDownsideReturn(portfolio,0.05))

dateStart = "2014-11-17 09:30:00"
dateEnd = "2014-11-17 16:00:00"
portfolio<-portfolio_create(dateStart,dateEnd)
portfolio_settings(portfolio,portfolioMetricsMode="price",windowLength = '3600s',
resultsSamplingInterval='60s')
portfolio_addPosition(portfolio,'AAPL',100)
portfolio_addPosition(portfolio,'C',300) 
portfolio_addPosition(portfolio,'GOOG',150)
util_plot2d(portfolio_expectedDownsideReturn(portfolio,0.05))
}}
\keyword{PortfolioEffectHFT}
\keyword{portfolio_expectedDownsideReturn}