% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.R
\docType{methods}
\name{up_percentage_ratio}
\alias{up_percentage_ratio}
\alias{up_percentage_ratio,portfolio-method}
\alias{up_percentage_ratio,position-method}
\title{Up Percentage Ratio}
\usage{
up_percentage_ratio(asset)
}
\arguments{
  \item{asset}{Portfolio or Position object created using \link[=portfolio_create]{portfolio_create( )} or \link[=position_add]{position_add( )} function}
}
\value{Metric object}
\description{Computes up percentage ratio of a portfolio.
}
\note{\url{https://www.portfolioeffect.com/docs/glossary/measures/relative-return-measures/up-percentage-ratio}
}
\author{Kostin Andrey <andrey.kostin@portfolioeffect.com>}
\seealso{\code{\link{down_percentage_ratio}} }
\examples{
\dontrun{
data(aapl.data) 
data(goog.data) 
data(spy.data) 
portfolio=portfolio_create(priceDataIx=spy.data)
portfolio_settings(portfolio,windowLength = '3600s',resultsSamplingInterval='60s')
positionGOOG=position_add(portfolio,'GOOG',100,priceData=goog.data)   
positionAAPL=position_add(portfolio,'AAPL',300,priceData=aapl.data) 
result=compute(up_percentage_ratio(portfolio),up_percentage_ratio(positionGOOG),
up_percentage_ratio(positionAAPL)) 
plot(up_percentage_ratio(portfolio),up_percentage_ratio(positionGOOG),
up_percentage_ratio(positionAAPL),legend=c('Portfolio','GOOG','AAPL'),title='Up Percentage Ratio')

dateStart = "2014-11-17 09:30:00"
dateEnd = "2014-11-17 16:00:00"
portfolio=portfolio_create(dateStart,dateEnd)
portfolio_settings(portfolio,portfolioMetricsMode="price",windowLength = '3600s',
resultsSamplingInterval='60s')
positionAAPL=position_add(portfolio,'AAPL',100)
positionC=position_add(portfolio,'C',300) 
positionGOOG=position_add(portfolio,'GOOG',150) 
result=compute(up_percentage_ratio(positionC),up_percentage_ratio(positionGOOG),
up_percentage_ratio(positionAAPL)) 
plot(up_percentage_ratio(positionC),up_percentage_ratio(positionGOOG),
up_percentage_ratio(positionAAPL),legend=c('C','GOOG','AAPL'),title='Up Percentage Ratio')
}}
\keyword{PortfolioEffectHFT}
%\concept{high frequency, intraday analytics, market data, portfolio, portfolio management,realtime analytics, risk, risk management, toolbox tools, trading, trading strategies}
\keyword{up_percentage_ratio}
