% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_data_processing.R
\name{expenditures}
\alias{expenditures}
\title{Providing expenditures of sold products}
\usage{
expenditures(data, period, set = c())
}
\arguments{
\item{data}{The user's data frame. It must contain columns: \code{time} (as Date in format: year-month-day, e.g. '2020-12-01'), \code{quantities} (as positive numeric) and \code{prodID} (as numeric, factor or character) with unique product IDs.}

\item{period}{The time period (as character) limited to the year and month, e.g. "2019-03".}

\item{set}{The set of unique product IDs to be used for determining expenditures of sold products (see also \code{\link{data_matching}}). If the \code{set} is empty, the function returns quantities of all products being available in \code{period}.}
}
\value{
The function analyzes the user's data frame and returns expenditures of products with given \code{ID} and being sold in the time period indicated by the \code{period} parameter. Please note that the function returns the expenditure values for sorted prodIDs and in the absence of a given prodID in the data set, the function returns nothing (it does not return zero).
}
\description{
The function returns expenditures of sold products with given IDs.
}
\examples{
\donttest{expenditures(milk, period="2019-06")}
expenditures(milk, period="2019-12",set=c(400032, 82919))
}
