% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_full_multilateral_indices.R
\name{utpd}
\alias{utpd}
\title{Calculating the unweighted multilateral TPD price index}
\usage{
utpd(data, start, end, wstart = start, window = 13)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric, factor or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{wstart}{The beginning of the time interval (which is used by multilateral methods) limited to the year and month, e.g. "2020-01".}

\item{window}{The length of the time window (as positive integer: typically multilateral methods are based on the 13-month time window).}
}
\value{
This function returns a value of the unweighted multilateral TPD price index which considers the time window defined by \code{wstart} and \code{window} parameters. It measures the price dynamics by comparing period \code{end} to period \code{start} (both \code{start} and \code{end} must be inside the considered time window). Please note, that the estimation procedure runs the Ordinary Least Squares (OLS) method instead of the Weighted Least Squares (WLS) method like in the case of the TPD index. To get information about both price index values and corresponding dates, please see functions:  \code{\link{price_indices}} or \code{\link{final_index}}. The function does not take into account aggregating over outlets or product subgroups (to consider these types of aggregating, please use the \code{\link{final_index}} function).
}
\description{
This function returns a value of the unweighted multilateral TPD (Time Product Dummy) price index.
}
\examples{
\donttest{utpd(milk, start="2019-01", end="2019-08",window=10)}
\donttest{utpd(milk, start="2018-12", end="2019-12")}
}
\references{
{de  Haan,  J.  and  F.  Krsinich  (2014). \emph{Time  Dummy  Hedonic  and  Quality-Adjusted  Unit Value Indexes: Do They Really Differ?} Paper presented at the Society for Economic Measurement Conference, 18-20 August 2014, Chicago, U.S.}
}
